/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractComponent;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfJSPTagNameHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        String error1;
        IFile documentFile = this.getFile();
        XModel xModel = JsfJSPTagNameHyperlink.getXModel((IFile)documentFile);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = this.getRequestProperties(region);
        p.put("file", documentFile);
        List list = provider.getList(xModel, "jsf.open.taglibrary", p.getProperty("prefix"), p);
        if (list != null && list.size() >= 1) {
            this.openFileInEditor((String)list.get(0));
            return;
        }
        String error = p.getProperty("error");
        if (error != null && (error1 = this.openJSF2Component(documentFile, p)) != null) {
            error = error1;
        }
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected String openJSF2Component(IFile documentFile, Properties p) {
        String uri = p.getProperty("prefix");
        if (uri == null || !uri.startsWith("http://java.sun.com/jsf/composite/")) {
            return null;
        }
        ITagLibrary[] ls = KbProjectFactory.getKbProject((IProject)documentFile.getProject(), (boolean)true).getTagLibraries(uri);
        if (ls == null || ls.length == 0) {
            return "Cannot find JSF 2 library " + uri;
        }
        String error = "";
        String tagName = p.getProperty("name");
        IComponent c = ls[0].getComponent(tagName);
        if (c != null) {
            IResource r = ((AbstractComponent)c).getResource();
            if (r instanceof IFile) {
                IEditorPart part = null;
                IFile f = (IFile)r;
                if (f.getFullPath() != null && f.getFullPath().toString().endsWith(".jar")) {
                    XModelObject o;
                    int q;
                    Object id = ((AbstractComponent)c).getId();
                    if (id instanceof XModelObject && (q = FindObjectHelper.findModelObject((XModelObject)(o = (XModelObject)id), (int)FindObjectHelper.IN_EDITOR_ONLY)) == 1) {
                        error = "Cannot open resource " + r.getName();
                    }
                } else {
                    part = this.openFileInEditor(f);
                    if (part == null) {
                        error = "Cannot open file " + r;
                    }
                }
            } else {
                error = "Cannot find file for tag " + tagName;
            }
        } else {
            error = "Component " + tagName + " not found in library " + p.getProperty("prefix");
        }
        return error;
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getURI(region);
        if (value != null) {
            p.setProperty("prefix", value);
        }
        if ((value = this.getTagName(region)) != null) {
            p.setProperty("name", value);
        }
        return p;
    }

    private String getURI(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Element)) {
                return null;
            }
            Node node = n;
            String nodeName = node.getNodeName();
            if (nodeName.indexOf(58) == -1) {
                return null;
            }
            String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
            if (nodePrefix == null || nodePrefix.length() == 0) {
                return null;
            }
            Map trackers = JSPRootHyperlinkPartitioner.getTrackersMap((IDocument)this.getDocument(), (int)region.getOffset());
            String string = trackers == null ? null : trackers.get(nodePrefix);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagName(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Element)) {
                return null;
            }
            Node node = n;
            String tagName = node.getNodeName();
            if (tagName.indexOf(58) == -1) {
                return null;
            }
            String string = tagName.substring(tagName.indexOf(58) + 1);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            int start = elem.getStartOffset();
            int nameStart = start + (elem.isEndTag() ? "</" : "<").length();
            int nameEnd = nameStart + tagName.length();
            if (nameStart > offset || nameEnd <= offset) {
                return null;
            }
            Region region = new Region(nameStart, nameEnd - nameStart);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String tagName = this.getTagName(this.fLastRegion);
        if (tagName == null) {
            return JSFTextExtMessages.OpenTagLibraryForATag;
        }
        return MessageFormat.format(JSFTextExtMessages.OpenTagLibraryForTagName, tagName);
    }
}

