/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPTagAttributeValueHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfJSPXmlNsHyperlinkPartitioner
extends JSPTagAttributeValueHyperlinkPartitioner {
    public static final String JSF_JSP_XMLNS_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSF_JSP_XMLNS";
    private String[] JSF_PROJECT_NATURES = new String[]{"org.jboss.tools.jsf.jsfnature"};

    protected String getPartitionType() {
        return JSF_JSP_XMLNS_PARTITION;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!this.recognizeNature(document)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            Attr xmlnsAttr = (Attr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:")) {
                return false;
            }
            Element rootElem = xmlnsAttr.getOwnerElement();
            return rootElem.getNodeName().equals("jsp:root");
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    protected boolean recognizeNature(IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            IFile documentFile = smw.getFile();
            if (documentFile == null) {
                return false;
            }
            IProject project = documentFile.getProject();
            int i = 0;
            while (i < this.JSF_PROJECT_NATURES.length) {
                if (project.getNature(this.JSF_PROJECT_NATURES[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return false;
        }
        finally {
            smw.dispose();
        }
    }

    public IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null) {
                return null;
            }
            int propStart = Utils.getValueStart((Node)n);
            int propLength = Utils.getValueEnd((Node)n) - propStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        finally {
            smw.dispose();
        }
    }
}

