/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.XModelBasedHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JsfTaglibDirectiveHyperlink
extends XModelBasedHyperlink {
    protected String getRequestMethod() {
        return "jsf.open.taglibrary";
    }

    private String getTaglibUri(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null || !(n instanceof Node)) {
                return null;
            }
            Node node = n;
            String uri = Utils.getAttributeValue((IDocument)this.getDocument(), (Node)node, (String)"uri");
            if (uri != null) {
                String string = uri;
                return string;
            }
        }
        finally {
            smw.dispose();
        }
        return null;
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String uri = this.getTaglibUri(region);
        if (uri != null) {
            p.setProperty("prefix", uri);
        }
        return p;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Node)) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null || !(n instanceof Node)) {
                return null;
            }
            int propStart = Utils.getValueStart((Node)n);
            if (propStart < 0) {
                return null;
            }
            int propLength = Utils.getValueEnd((Node)n) - propStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String uri = this.getTaglibUri(this.fLastRegion);
        if (uri == null) {
            return MessageFormat.format(Messages.OpenA, Messages.TagLibrary);
        }
        return MessageFormat.format(Messages.OpenTagLibraryForUri, uri);
    }
}

