/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PropertyHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        XModel xModel = this.getXModel();
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        String propertyName = this.getPropertyName(region);
        String beanClassName = this.getBeanClassName(region);
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = new Properties();
        p.setProperty("ignoreWarning", "true");
        p.setProperty("property", propertyName);
        beanClassName = String.valueOf(beanClassName.replace('.', '/')) + ".class";
        provider.getList(xModel, "jsf.open.property", beanClassName, p);
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private String getPropertyName(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        try {
            return this.trimQuotes(this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private String getBeanClassName(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Text) {
                n = n.getParentNode();
            }
            n = n.getParentNode().getParentNode();
            Element beanElement = (Element)n;
            String beanName = beanElement.getNodeName();
            String beanClassElementName = String.valueOf(beanName) + "-class";
            NodeList children = beanElement.getElementsByTagName(beanClassElementName);
            Node beanClassElement = null;
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof Element) {
                    beanClassElement = (Element)children.item(i);
                    break;
                }
                ++i;
            }
            if (beanClassElement == null) {
                return null;
            }
            children = beanClassElement.getChildNodes();
            String beanClassName = null;
            int i2 = 0;
            while (children != null && i2 < children.getLength()) {
                if (children.item(i2) instanceof Text) {
                    Text xmlText = (Text)children.item(i2);
                    int start = Utils.getValueStart((Node)xmlText);
                    int end = Utils.getValueEnd((Node)xmlText);
                    if (start >= 0) {
                        beanClassName = this.getDocument().get(start, end - start);
                        break;
                    }
                }
                ++i2;
            }
            if (beanClassName == null) {
                return null;
            }
            String string = (beanClassName = this.trimQuotes(beanClassName)).length() == 0 ? null : beanClassName;
            return string;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private String trimQuotes(String word) {
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        return sb.substring(bStart, ++bEnd);
    }

    public String getHyperlinkText() {
        String beanClassName = this.getBeanClassName(this.fLastRegion);
        String propertyName = this.getPropertyName(this.fLastRegion);
        if (beanClassName == null || propertyName == null) {
            return MessageFormat.format(Messages.OpenA, JSFTextExtMessages.BeanProperty);
        }
        return MessageFormat.format(JSFTextExtMessages.OpenBeanProperty, beanClassName, propertyName);
    }
}

