/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RenderKitHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        if (this.getDocument() == null || region == null) {
            this.openFileFailed();
            return;
        }
        XModel xModel = this.getXModel();
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        String beanName = this.getBeanName(this.getRegion(region.getOffset()));
        Properties p = new Properties();
        provider.getList(xModel, "jsf.open.render-kit", beanName, p);
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    private String getBeanName(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        try {
            return this.trimQuotes(this.getDocument().get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private String trimQuotes(String word) {
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        return sb.substring(bStart, ++bEnd);
    }

    public String getHyperlinkText() {
        String renderKitName = this.getBeanName(this.fLastRegion);
        if (renderKitName == null) {
            return MessageFormat.format(Messages.OpenA, JSFTextExtMessages.RenderKit);
        }
        return MessageFormat.format(JSFTextExtMessages.OpenRenderKit, renderKitName);
    }
}

