/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.core.resources;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.markers.ResourceProblems;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.PositionHolder;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.VTaskListener;
import org.jboss.tools.common.verification.vrules.core.resources.VerificationMarkers;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;

public class VTaskListenerImpl
implements VTaskListener {
    protected VTask task;
    protected XModel model;
    protected int errors = 0;
    protected Map<XModelObject, ResourceProblems> problemList = new HashMap<XModelObject, ResourceProblems>();
    protected int significance = 0;
    int limit = -2;

    public void setModel(XModel model) {
        this.model = model;
    }

    public void setTask(VTask task) {
        this.task = task;
    }

    public void setSignificance(int significance) {
        this.significance = significance;
    }

    public void onStart() {
        this.errors = 0;
        this.problemList.clear();
    }

    public void onRuleApplied(VRule rule, VObject object, VResult[] results) {
        if (!rule.isEnabled()) {
            return;
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                if (results[i] != null && results[i].getSignificance() > this.significance) {
                    ++this.errors;
                    if (this.getErrorCountLimit() >= 0 && this.errors > this.getErrorCountLimit()) {
                        if (this.errors == this.getErrorCountLimit() + 1) {
                            this.task.stop();
                        }
                    } else {
                        this.addProblem(rule, object, results[i]);
                    }
                }
                ++i;
            }
        } else {
            this.addProblem(rule, object, null);
        }
    }

    public void onRuleFinished(VRule rule, VObject object) {
        this.onRuleApplied(rule, object, null);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onFinish() {
        this.addMarkers();
        this.task.removeTaskListener(this);
    }

    protected void addProblem(VRule rule, VObject object, VResult result) {
        String attr;
        String msg;
        XModelObject o;
        VObjectImpl oi = (VObjectImpl)object;
        XModelObject xModelObject = o = oi == null ? null : oi.getModelObject();
        if (o == null) {
            return;
        }
        XModelObject f = o;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (!(f instanceof FileAnyImpl)) {
            return;
        }
        ResourceProblems p = this.problemList.get(f);
        String string = msg = result == null ? null : result.getMessage();
        if (p == null) {
            p = new ResourceProblems(f);
            this.problemList.put(f, p);
        }
        Object sp = result == null ? null : result.getSourcePosition();
        String string2 = attr = sp == null ? null : sp.toString();
        if (msg != null) {
            PositionHolder h = PositionHolder.getPosition((XModelObject)o, (String)attr);
            h.update();
            p.addError(o.getPath(), msg, attr, h);
        }
    }

    protected void addMarkers() {
        for (ResourceProblems p : this.problemList.values()) {
            VerificationMarkers markers = new VerificationMarkers(p);
            markers.setModelObject(p.getResourceObject());
            markers.update();
        }
    }

    protected int getErrorCountLimit() {
        if (this.limit != -2) {
            return this.limit;
        }
        String path = "%Options%/Struts Studio/Verification";
        String attr = "Reported Errors Number Limit";
        XModelObject o = PreferenceModelUtilities.getPreferenceModel().getByPath(path);
        if (o == null) {
            this.limit = -1;
            return -1;
        }
        String s = o.getAttributeValue(attr);
        this.limit = -1;
        if (!"unlimited".equals(s) && s != null && s.length() > 0) {
            try {
                this.limit = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return this.limit;
    }
}

