/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.verification.Messages;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.handler.VerifyHandler;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class VerifyRulesAllHandler
extends VerifyHandler {
    private boolean gui = true;

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.gui) {
            this.executeHandlerDefault(object, p);
        } else {
            this.executeHandlerGUI(object, p);
        }
    }

    public boolean isEnabled(XModelObject object) {
        return VHelper.getManager() != null;
    }

    private void executeHandlerDefault(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        VModel vmodel = VModelFactory.getModel(object.getModel());
        HashMap<String, ArrayList<VRule>> entities = new HashMap<String, ArrayList<VRule>>();
        VRuleSet[] ruleSets = VHelper.getManager().getRuleSets();
        int k = 0;
        while (k < ruleSets.length) {
            if (ruleSets[k].isEnabled()) {
                VRule[] rules = ruleSets[k].getRules();
                int i = 0;
                while (i < rules.length) {
                    VRule rule = rules[i];
                    if (rule.isEnabled() && rule.getAction() != null) {
                        VEntity[] ent = rule.getEntities();
                        int j = 0;
                        while (j < ent.length) {
                            String name = ent[j].getName();
                            ArrayList<VRule> r = (ArrayList<VRule>)entities.get(name);
                            if (r == null) {
                                r = new ArrayList<VRule>();
                                entities.put(name, r);
                            }
                            r.add(rule);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
        VObject vobject = vmodel.getObjectByPath(object.getPath());
        this.check(entities, vobject, object.getModel());
    }

    private void executeHandlerGUI(XModelObject object, Properties p) throws XModelException {
        SpecialWizard wizard = SpecialWizardFactory.createSpecialWizard((String)"org.jboss.tools.common.verification.ui.vrules.wizard.runtime2.VerifyWizard");
        if (p == null) {
            p = new Properties();
        }
        String title = Messages.VerifyRulesAllHandler_ApplyVerificationRules;
        if (!object.getModelEntity().getName().equals("FileSystems")) {
            title = NLS.bind((String)Messages.VerifyRulesAllHandler_ApplyVerificationRulesForObject, (Object)object.getPresentationString());
        }
        p.setProperty("title", title);
        p.setProperty("help", "ApplyVerificationRules");
        wizard.setObject((Object)new Object[]{object, p});
        wizard.execute();
    }
}

