/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VMessageFormat;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.impl.VTaskImpl;

public class VManagerImpl
implements VManager {
    protected VRuleSet[] ruleSets;
    protected VModel model;
    protected int significance;
    protected VMessageFormat format;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public VModel getModel() {
        return this.model;
    }

    public void setModel(VModel model) {
        this.model = model;
    }

    public VRuleSet[] getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(VRuleSet[] ruleSets) {
        if (this.ruleSets == ruleSets) {
            return;
        }
        this.deactivateRuleSets(this.ruleSets);
        this.ruleSets = ruleSets;
        this.activateRuleSets(ruleSets);
    }

    public void loadRuleSet(VRuleSet ruleSet) {
        int length = this.ruleSets.length;
        VRuleSet[] newSets = new VRuleSet[length + 1];
        System.arraycopy(this.ruleSets, 0, newSets, 0, length);
        newSets[length] = ruleSet;
        this.ruleSets = newSets;
        this.activateRuleSet(ruleSet);
        if (ruleSet != null) {
            this.activateRuleSets(ruleSet.getRuleSets());
        }
    }

    public void unloadRuleSet(VRuleSet ruleSet) {
        int length = this.ruleSets.length;
        int i = 0;
        while (i < length) {
            if (this.ruleSets[i] == ruleSet) {
                this.deactivateRuleSet(ruleSet);
                VRuleSet[] newSets = new VRuleSet[length - 1];
                System.arraycopy(this.ruleSets, 0, newSets, 0, i);
                System.arraycopy(this.ruleSets, i + 1, newSets, i, length - i - 1);
                this.ruleSets = newSets;
                return;
            }
            ++i;
        }
    }

    public void updateRuleSet(VRuleSet ruleSet) {
        this.unloadRuleSet(ruleSet);
        this.loadRuleSet(ruleSet);
    }

    private void activateRuleSets(VRuleSet[] ruleSets) {
        if (ruleSets == null) {
            return;
        }
        int i = 0;
        while (i < ruleSets.length) {
            this.activateRuleSet(ruleSets[i]);
            this.activateRuleSets(ruleSets[i].getRuleSets());
            ++i;
        }
    }

    private void activateRuleSet(VRuleSet ruleSet) {
        VRule[] rules = ruleSet.getRules();
        int i = 0;
        while (i < rules.length) {
            VEntity[] entities = rules[i].getEntities();
            int j = 0;
            while (j < entities.length) {
                if (entities[j] != null) {
                    entities[j].addRule(rules[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void deactivateRuleSets(VRuleSet[] ruleSets) {
        if (ruleSets == null) {
            return;
        }
        int i = 0;
        while (i < ruleSets.length) {
            this.deactivateRuleSet(ruleSets[i]);
            this.deactivateRuleSets(ruleSets[i].getRuleSets());
            ++i;
        }
    }

    private void deactivateRuleSet(VRuleSet ruleSet) {
        VRule[] rules = ruleSet.getRules();
        int i = 0;
        while (i < rules.length) {
            VEntity[] entities = rules[i].getEntities();
            int j = 0;
            while (j < entities.length) {
                if (entities[j] != null) {
                    entities[j].removeRule(rules[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    public int getMinSignificance() {
        return this.significance;
    }

    public void setMinSignificance(int significance) {
        int oldSignificance = this.significance;
        this.significance = significance;
        this.propertyChangeSupport.firePropertyChange("minSignificance", oldSignificance, significance);
    }

    public VMessageFormat getMessageFormat() {
        return this.format;
    }

    public void setMessageFormat(VMessageFormat format) {
        this.format = format;
    }

    public VTask createTask(VObject object) {
        return new VTaskImpl(this, object);
    }

    public VTask createTask(VObject object, VRule[] rules) {
        return new VTaskImpl(object, rules);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

