/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.VTaskListener;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;

public class VTaskImpl
implements VTask,
Runnable {
    private VObject object;
    private VRule[] rules;
    private int index = 0;
    private List<VTaskListener> listeners = new ArrayList<VTaskListener>();
    private Thread thread;
    private boolean running = false;
    private boolean sleeping = false;

    public VTaskImpl(VManager manager, VObject object) {
        this.object = object;
        this.rules = VHelper.getRules(manager, object);
    }

    public VTaskImpl(VObject object, VRule[] rules) {
        this.object = object;
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "VTask");
            this.thread.start();
        } else if (this.sleeping) {
            VTaskImpl vTaskImpl = this;
            synchronized (vTaskImpl) {
                this.sleeping = false;
                try {
                    this.notifyAll();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void pause() {
        if (this.running && !this.sleeping) {
            this.sleeping = true;
        }
    }

    public void stop() {
        this.sleeping = false;
        this.running = false;
    }

    public void run() {
        this.notifyStarted();
        if (this.rules != null) {
            this.index = 0;
            while (this.index < this.rules.length) {
                if (!this.running) break;
                VRule rule = this.rules[this.index];
                if (rule.isEnabled() && rule.getAction() != null && rule.getRuleSet().isEnabled()) {
                    this.apply(rule, this.object);
                }
                this.notifyRuleFinished(rule, this.object);
                ++this.index;
            }
        }
        this.notifyFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSleeping() {
        if (this.sleeping) {
            VTaskImpl vTaskImpl = this;
            synchronized (vTaskImpl) {
                if (this.sleeping) {
                    this.notifyPause();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!this.sleeping) {
                        this.notifyResume();
                    }
                }
            }
        }
    }

    private void apply(VRule rule, VObject object) {
        VEntity entity = object.getEntity();
        VEntity[] entities = rule.getEntities();
        boolean checkChildren = false;
        boolean checked = false;
        int i = 0;
        while (i < entities.length) {
            if (!this.running) {
                return;
            }
            this.checkSleeping();
            if (!this.running) {
                return;
            }
            if (entity != null && entities[i] != null && entity.getName().equals(entities[i].getName())) {
                VAction action = rule.getAction();
                if (action != null) {
                    VResult[] results = action.check(object);
                    this.notifyApplied(rule, object, results);
                    checked = true;
                    if (checkChildren) {
                        break;
                    }
                }
            } else if (entity.isDescendant(entities[i].getName())) {
                checkChildren = true;
                if (checked) break;
            }
            ++i;
        }
        if (checkChildren) {
            VObject[] children = object.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                this.apply(rule, children[i2]);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStarted() {
        this.running = true;
        this.sleeping = false;
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                SafeRunner.run((ISafeRunnable)new OnStartNotifier(this.listeners.get(i)));
                ++i;
            }
        }
    }

    private void logListener(VTaskListener listener, Throwable e) {
        VerificationPlugin.getPluginLog().logInfo("Exception in listener " + listener + " ignored: " + e, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyApplied(VRule rule, VObject object, VResult[] results) {
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                SafeRunner.run((ISafeRunnable)new OnRuleAppliedNotifier(this.listeners.get(i), rule, object, results));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRuleFinished(VRule rule, VObject object) {
        if (!this.running) {
            return;
        }
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                SafeRunner.run((ISafeRunnable)new OnRuleFinishedNotifier(this.listeners.get(i), rule, object));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPause() {
        if (!this.running) {
            return;
        }
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                SafeRunner.run((ISafeRunnable)new OnPauseNotifier(this.listeners.get(i)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResume() {
        if (!this.running) {
            return;
        }
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            int i = 0;
            while (i < this.listeners.size()) {
                SafeRunner.run((ISafeRunnable)new OnResumeNotifier(this.listeners.get(i)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFinish() {
        this.sleeping = false;
        this.running = false;
        this.thread = null;
        VTaskListener[] ls = null;
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new VTaskListener[0]);
        }
        int i = 0;
        while (i < ls.length) {
            SafeRunner.run((ISafeRunnable)new OnFinishNotifier(ls[i]));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(VTaskListener listener) {
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(VTaskListener listener) {
        List<VTaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public class OnFinishNotifier
    extends SafeNotifier {
        public OnFinishNotifier(VTaskListener listener) {
            super(listener);
        }

        public void run() throws Exception {
            this.listener.onFinish();
        }
    }

    public class OnPauseNotifier
    extends SafeNotifier {
        public OnPauseNotifier(VTaskListener listener) {
            super(listener);
        }

        public void run() throws Exception {
            this.listener.onPause();
        }
    }

    public class OnResumeNotifier
    extends SafeNotifier {
        public OnResumeNotifier(VTaskListener listener) {
            super(listener);
        }

        public void run() throws Exception {
            this.listener.onResume();
        }
    }

    public class OnRuleAppliedNotifier
    extends OnRuleFinishedNotifier {
        VResult[] results;

        public OnRuleAppliedNotifier(VTaskListener listener, VRule rule, VObject object, VResult[] results) {
            super(listener, rule, object);
            this.results = results;
        }

        public void run() throws Exception {
            this.listener.onRuleApplied(this.rule, this.object, this.results);
        }
    }

    public class OnRuleFinishedNotifier
    extends SafeNotifier {
        VRule rule;
        VObject object;

        public OnRuleFinishedNotifier(VTaskListener listener, VRule rule, VObject object) {
            super(listener);
            this.rule = rule;
            this.object = object;
        }

        public void run() throws Exception {
            this.listener.onRuleFinished(this.rule, this.object);
        }
    }

    public class OnStartNotifier
    extends SafeNotifier {
        public OnStartNotifier(VTaskListener listener) {
            super(listener);
        }

        public void run() throws Exception {
            this.listener.onStart();
        }
    }

    public class SafeNotifier
    implements ISafeRunnable {
        protected VTaskListener listener;

        public SafeNotifier(VTaskListener listener) {
            this.listener = listener;
        }

        public void run() throws Exception {
            this.listener.onStart();
        }

        public void handleException(Throwable exception) {
            VTaskImpl.this.logListener(this.listener, exception);
        }
    }
}

