/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.layer;

import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;

public class VObjectImpl
implements VObject {
    private XModelObject modelObject;
    private VModel model;
    static VObject[] EMPTY_CHILDREN = new VObject[0];

    public VObjectImpl(XModelObject modelObject, VModel model) {
        this.modelObject = modelObject;
        this.model = model;
    }

    public Object getAttribute(String name) {
        return this.modelObject.getAttributeValue(name);
    }

    public VObject getChild(String path) {
        XModelObject child = this.modelObject.getChildByPath(path);
        return child == null ? null : new VObjectImpl(child, this.model);
    }

    public VObject[] getChildren() {
        if ("true".equals(this.modelObject.get("overlapped"))) {
            return EMPTY_CHILDREN;
        }
        if (this.modelObject.getModelEntity().getName().equals("FileSystemJar")) {
            return EMPTY_CHILDREN;
        }
        XModelObject[] c = this.modelObject.getChildren();
        VObject[] children = new VObject[c.length];
        int i = 0;
        while (i < c.length) {
            children[i] = new VObjectImpl(c[i], this.model);
            ++i;
        }
        return children;
    }

    public VEntity getEntity() {
        return this.model.getEntity(this.modelObject.getModelEntity().getName());
    }

    public VModel getModel() {
        return this.model;
    }

    public VObject getParent() {
        XModelObject p = this.modelObject.getParent();
        return p == null ? null : new VObjectImpl(p, this.model);
    }

    public String getPath() {
        return this.modelObject.getPath();
    }

    public XModelObject getModelObject() {
        return this.modelObject;
    }

    public long getTimeStamp() {
        return this.modelObject.getTimeStamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VObjectImpl) {
            return ((VObjectImpl)o).modelObject.equals(this.modelObject);
        }
        return false;
    }

    public int hashCode() {
        return this.modelObject.hashCode();
    }

    public String toString() {
        return FindObjectHelper.makeRef((String)this.getPath(), (String)DefaultCreateHandler.title((XModelObject)this.modelObject, (boolean)true));
    }
}

