/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.verification.vrules.VMessageFormat;
import org.jboss.tools.common.verification.vrules.VResultTemplate;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.model.VRuleModel;

public class VResultTemplateModel
extends RegularObjectImpl
implements PropertyChangeListener {
    private static final long serialVersionUID = 7552672438471347238L;
    protected VResultTemplate template;

    public VResultTemplate getTemplate(VRule rule) {
        if (this.template == null) {
            this.template = new VResultTemplate();
            this.template.setId(this.getAttributeValue("id"));
            this.template.setName(this.getAttributeValue("name"));
            this.template.setDescription(this.getAttributeValue("description"));
            this.template.setType(this.getAttributeValue("type"));
            String s = this.getAttributeValue("significance");
            try {
                this.template.setSignificance(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {}
            this.template.setFormat(this.getFormat(this.getAttributeValue("message id"), rule));
            this.template.addPropertyChangeListener(this);
        }
        return this.template;
    }

    public VMessageFormat getFormat(String messageId, VRule rule) {
        return rule.getRuleSet().getMessageFormat(messageId);
    }

    public String setAttributeValue(String name, String value) {
        String result = super.setAttributeValue(name, value);
        if (this.template != null) {
            if ("id".equals(name)) {
                this.template.setId(result);
            } else if ("name".equals(name)) {
                this.template.setName(result);
            } else if ("description".equals(name)) {
                this.template.setDescription(result);
            } else if ("type".equals(name)) {
                this.template.setType(result);
            } else if ("significance".equals(name)) {
                try {
                    this.template.setSignificance(Integer.parseInt(result));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("message id".equals(name)) {
                this.template.setFormat(this.getFormat(result, ((VRuleModel)this.getParent()).getRule(null)));
            }
        }
        return result;
    }

    public String getPathPart() {
        return this.getAttributeValue("id");
    }

    public String getPresentationString() {
        return this.getAttributeValue("name");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String value;
        VMessageFormat format;
        String name = evt.getPropertyName();
        if ("id".equals(name) || "name".equals(name) || "description".equals(name) || "type".equals(name) || "significance".equals(name)) {
            String value2 = "" + evt.getNewValue();
            if (!value2.equals(this.getAttributeValue(name))) {
                this.setAttributeValue(name, value2);
                this.setModified(true);
            }
        } else if ("format".equals(name) && (format = (VMessageFormat)evt.getNewValue()) != null && !(value = format.getId()).equals(this.getAttributeValue("message id"))) {
            this.setAttributeValue("message id", value);
            this.setModified(true);
        }
    }
}

