/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.parser;

import java.util.List;
import java.util.Stack;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.core.parser.Tokenizer;
import org.jboss.tools.common.el.core.parser.TokenizerFactory;
import org.jboss.tools.common.el.internal.core.model.ELModelImpl;
import org.jboss.tools.common.el.internal.core.parser.ELParserImpl;

public class ELParserUtil {
    private static ELParserFactory DEFAULT_FACTORY = new DefaultFactory(){

        public ELParser newParser() {
            return new DefaultParser(){

                protected Tokenizer createTokenizer() {
                    return TokenizerFactory.createDefaultTokenizer();
                }

                public void dispose() {
                    super.dispose();
                    this.release(this);
                }
            };
        }
    };
    private static ELParserFactory COLLECTION_FACTORY = new DefaultFactory(){

        public ELParser newParser() {
            return new DefaultParser(){

                protected Tokenizer createTokenizer() {
                    return TokenizerFactory.createCollectionTokenizer();
                }

                public void dispose() {
                    super.dispose();
                    this.release(this);
                }
            };
        }
    };
    private static ELParserFactory JBOSS_FACTORY = new DefaultFactory(){

        public ELParser newParser() {
            return new DefaultParser(){

                protected Tokenizer createTokenizer() {
                    return TokenizerFactory.createJbossTokenizer();
                }

                public void dispose() {
                    super.dispose();
                    this.release(this);
                }
            };
        }
    };

    public static ELParserFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public static ELParserFactory getCollectionFactory() {
        return COLLECTION_FACTORY;
    }

    public static ELParserFactory getJbossFactory() {
        return JBOSS_FACTORY;
    }

    private static abstract class DefaultFactory
    implements ELParserFactory {
        protected Stack<ELParser> inUse = new Stack();
        protected Stack<ELParser> free = new Stack();

        private DefaultFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ELParser createParser() {
            DefaultFactory defaultFactory = this;
            synchronized (defaultFactory) {
                if (!this.free.isEmpty()) {
                    ELParser parser = this.free.pop();
                    this.inUse.push(parser);
                    return parser;
                }
            }
            ELParser parser = this.newParser();
            DefaultFactory defaultFactory2 = this;
            synchronized (defaultFactory2) {
                this.inUse.push(parser);
            }
            return parser;
        }

        protected abstract ELParser newParser();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ELParser parser) {
            DefaultFactory defaultFactory = this;
            synchronized (defaultFactory) {
                boolean b = this.inUse.remove(parser);
                if (!b) {
                    return;
                }
                this.free.push(parser);
            }
        }
    }

    private static abstract class DefaultParser
    implements ELParser {
        ELParserImpl impl = new ELParserImpl();
        List<SyntaxError> errors = null;
        Tokenizer t = this.createTokenizer();

        private DefaultParser() {
        }

        public ELModel parse(String source) {
            return this.parse(source, 0, source.length());
        }

        public ELModel parse(String source, int start, int length) {
            try {
                LexicalToken token = this.t.parse(source, start, length);
                this.errors = this.t.getErrors();
                ELModelImpl model = this.impl.parse(token);
                model.setSource(source);
                model.setErrors(this.errors);
                ELModelImpl eLModelImpl = model;
                return eLModelImpl;
            }
            finally {
                this.t.dispose();
                this.dispose();
            }
        }

        protected abstract Tokenizer createTokenizer();

        public void dispose() {
            this.errors = null;
        }
    }
}

