/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.text.TextProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELResolutionImpl
implements ELResolution {
    protected ELContext context;
    protected List<ELSegment> segments = new ArrayList<ELSegment>();
    protected ELExpression operand;
    protected Set<TextProposal> proposals = new HashSet<TextProposal>();
    protected ELInvocationExpression lastResolvedToken;
    protected boolean mapOrCollectionOrBundleAmoungTheTokens;
    protected String value;

    public ELResolutionImpl(ELExpression operand) {
        this.setSourceOperand(operand);
    }

    @Override
    public List<ELSegment> findSegmentsByVariable(IVariable variable) {
        ArrayList<ELSegment> list = new ArrayList<ELSegment>();
        for (ELSegment segment : this.segments) {
            if (!segment.isResolved()) continue;
            for (IVariable var : segment.getVariables()) {
                if (!var.getName().equals(variable.getName())) continue;
                list.add(segment);
            }
        }
        return list;
    }

    @Override
    public List<ELSegment> findSegmentsByJavaElement(IJavaElement element) {
        ArrayList<ELSegment> list = new ArrayList<ELSegment>();
        for (ELSegment segment : this.segments) {
            JavaMemberELSegment javaSegment;
            if (!segment.isResolved() || !(segment instanceof JavaMemberELSegment) || (javaSegment = (JavaMemberELSegment)segment).getJavaElement() == null || !javaSegment.getJavaElement().equals(element)) continue;
            list.add(segment);
        }
        return list;
    }

    @Override
    public ELSegment findSegmentByOffset(int offset) {
        for (ELSegment segment : this.segments) {
            if (segment.getSourceReference() == null || segment.getSourceReference().getStartPosition() > offset || segment.getSourceReference().getStartPosition() + segment.getSourceReference().getLength() <= offset) continue;
            return segment;
        }
        return null;
    }

    @Override
    public ELContext getContext() {
        return this.context;
    }

    @Override
    public List<ELSegment> getSegments() {
        return this.segments;
    }

    public void addSegment(ELSegment segment) {
        this.segments.add(segment);
    }

    @Override
    public ELExpression getSourceOperand() {
        return this.operand;
    }

    @Override
    public ELSegment getUnresolvedSegment() {
        for (ELSegment segment : this.segments) {
            if (segment.isResolved()) continue;
            return segment;
        }
        return null;
    }

    @Override
    public boolean isResolved() {
        return !this.segments.isEmpty() && this.getUnresolvedSegment() == null;
    }

    public Set<TextProposal> getProposals() {
        return this.proposals;
    }

    public void setProposals(Set<TextProposal> proposals) {
        this.proposals = proposals;
    }

    public void setSourceOperand(ELExpression operand) {
        this.operand = operand;
    }

    public void setContext(ELContext context) {
        this.context = context;
    }

    public void setSegments(List<ELSegment> segments) {
        this.segments = segments;
    }

    public ELInvocationExpression getLastResolvedToken() {
        return this.lastResolvedToken;
    }

    public void setLastResolvedToken(ELInvocationExpression lastResolvedToken) {
        this.lastResolvedToken = lastResolvedToken;
    }

    public boolean isMapOrCollectionOrBundleAmoungTheTokens() {
        return this.mapOrCollectionOrBundleAmoungTheTokens;
    }

    public void setMapOrCollectionOrBundleAmoungTheTokens(boolean mapOrCollectionOrBundleAmoungTheTokens) {
        this.mapOrCollectionOrBundleAmoungTheTokens = mapOrCollectionOrBundleAmoungTheTokens;
    }

    @Override
    public ELSegment getLastSegment() {
        if (!this.getSegments().isEmpty()) {
            return this.getSegments().get(this.getSegments().size() - 1);
        }
        return null;
    }

    @Override
    public int getNumberOfResolvedSegments() {
        int i = 0;
        for (ELSegment segment : this.segments) {
            if (!segment.isResolved()) break;
            ++i;
        }
        return i;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.operand.toString();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        if (this.segments != null) {
            StringBuffer result = new StringBuffer("[");
            for (ELSegment segment : this.segments) {
                result.append(segment.toString()).append(';');
            }
            result.append(']');
            return result.toString();
        }
        return super.toString();
    }
}

