/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactory;

public class ELResolverFactoryManager {
    private static final ELResolverFactoryManager INSTANCE = new ELResolverFactoryManager();

    private ELResolverFactoryManager() {
    }

    public static ELResolverFactoryManager getInstance() {
        return INSTANCE;
    }

    public ELResolver[] getResolvers(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return new ELResolver[0];
        }
        HashSet<ELResolver> resolverSet = new HashSet<ELResolver>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.common.el.core.elResolver");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement[] natures = elements[j].getChildren("project-nature");
                int k = 0;
                while (k < natures.length) {
                    String natureId = natures[k].getAttribute("id");
                    try {
                        if (project.hasNature(natureId)) {
                            Object resolver = natures[k].createExecutableExtension("resolver-class");
                            if (resolver instanceof ELResolver) {
                                resolverSet.add((ELResolver)resolver);
                            } else {
                                ELCorePlugin.getPluginLog().logError(String.valueOf(resolver.getClass().getName()) + " must be instance of org.jboss.tools.common.el.core.resolver.ELResolver");
                            }
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        ELCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    catch (CoreException e) {
                        ELCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    ++k;
                }
                IConfigurationElement[] factories = elements[j].getChildren("factory");
                int k2 = 0;
                while (k2 < factories.length) {
                    try {
                        Object factory = factories[k2].createExecutableExtension("class");
                        if (factory instanceof ELResolverFactory) {
                            ELResolver resolver = ((ELResolverFactory)factory).createResolver(resource);
                            if (resolver != null) {
                                resolverSet.add(resolver);
                            }
                        } else {
                            ELCorePlugin.getPluginLog().logError(String.valueOf(factory.getClass().getName()) + " must be instance of org.jboss.tools.common.el.core.resolver.ELResolverFactory");
                        }
                    }
                    catch (CoreException e) {
                        ELCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        return resolverSet.toArray(new ELResolver[0]);
    }
}

