/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.Var;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElVarSearcher {
    private static final String VAR_ATTRIBUTE_NAME = "var";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private IFile file;
    private ELCompletionEngine engine;

    public ElVarSearcher(IFile file, ELCompletionEngine engine) {
        this.file = file;
        this.engine = engine;
    }

    public ElVarSearcher(ELCompletionEngine engine) {
        this(null, engine);
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public static Node getNode(ITextViewer viewer, int offset) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
        if (treeNode instanceof Node) {
            return (Node)treeNode;
        }
        return null;
    }

    public static Node getNode(IFile file, int offset) {
        IndexedRegion treeNode = ElVarSearcher.getNodeAt(file, offset);
        if (treeNode instanceof Node) {
            return (Node)treeNode;
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexedRegion getNodeAt(IFile file, int documentOffset) {
        if (file == null) {
            return null;
        }
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            try {
                model = mm.getModelForRead(file);
            }
            catch (IOException e) {
                ELCorePlugin.getDefault().logError(e);
                return null;
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError(e);
                return null;
            }
        }
        try {
            block12: {
                int lastOffset;
                block11: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block11;
                    if (node != null) return node;
                    if (lastOffset < 0) break block12;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public List<Var> findAllVars(ITextViewer viewer, int offset) {
        Node node = ElVarSearcher.getNode(viewer, offset);
        if (node != null) {
            return this.findAllVars(node);
        }
        return Collections.emptyList();
    }

    public List<Var> findAllVars(IFile file, int offset) {
        return ElVarSearcher.findAllVars(file, offset, this.engine.getParserFactory());
    }

    public static List<Var> findAllVars(ELContext context, int offset, ELResolver resolver) {
        Node node = ElVarSearcher.getNode(context.getResource(), offset);
        if (node != null) {
            return ElVarSearcher.findAllVars(node, resolver.getParserFactory());
        }
        return Collections.emptyList();
    }

    public static List<Var> findAllVars(IFile file, int offset, ELParserFactory factory) {
        Node node = ElVarSearcher.getNode(file, offset);
        if (node != null) {
            return ElVarSearcher.findAllVars(node, factory);
        }
        return Collections.emptyList();
    }

    public static List<Var> findAllVars(ITextViewer viewer, int offset, ELParserFactory factory) {
        Node node = ElVarSearcher.getNode(viewer, offset);
        if (node != null) {
            return ElVarSearcher.findAllVars(node, factory);
        }
        return Collections.emptyList();
    }

    public List<Var> findAllVars(Node node) {
        return ElVarSearcher.findAllVars(node, this.engine.getParserFactory());
    }

    public static List<Var> findAllVars(Node node, ELParserFactory factory) {
        ArrayList<Var> vars = new ArrayList<Var>();
        Node parentNode = node;
        while (parentNode != null) {
            Var var = ElVarSearcher.findVar(parentNode, factory);
            if (var != null) {
                vars.add(0, var);
            }
            parentNode = parentNode.getParentNode();
        }
        return vars;
    }

    public Var findVar(IFile file, int offset) {
        Node node = ElVarSearcher.getNode(file, offset);
        if (node != null) {
            return this.findVar(node);
        }
        return null;
    }

    public Var findVar(Node node) {
        return ElVarSearcher.findVar(node, this.engine.getParserFactory());
    }

    public static Var findVar(Node node, ELParserFactory factory) {
        Element element;
        String var;
        if (node != null && 1 == node.getNodeType() && (var = (element = (Element)node).getAttribute(VAR_ATTRIBUTE_NAME)) != null) {
            Var newVar;
            String value;
            int declOffset = 0;
            int declLength = 0;
            Attr varAttr = element.getAttributeNode(VAR_ATTRIBUTE_NAME);
            if (varAttr instanceof IDOMAttr) {
                int varNameStart = ((IDOMAttr)varAttr).getNameRegionStartOffset();
                int varNameEnd = ((IDOMAttr)varAttr).getNameRegionEndOffset();
                declOffset = varNameStart;
                declLength = varNameEnd - varNameStart;
            }
            if (!"".equals(var = var.trim()) && (value = element.getAttribute(VALUE_ATTRIBUTE_NAME)) != null && (newVar = new Var(factory, var, value = value.trim(), declOffset, declLength)).getElToken() != null) {
                return newVar;
            }
        }
        return null;
    }

    public Var findVarForEl(String el, List<Var> vars, boolean initializeNestedVars) {
        if (vars != null) {
            ArrayList<Var> parentVars = new ArrayList<Var>();
            for (Var var : vars) {
                String varName;
                ELExpression token = var.getElToken();
                if (token != null && !token.getText().endsWith(".") && (el.equals(varName = var.getName()) || el.startsWith(String.valueOf(varName.trim()) + "."))) {
                    Var parentVar;
                    if (var.getElToken() != null && initializeNestedVars && (parentVar = this.findVarForEl(var.getElToken().getText(), parentVars, true)) != null) {
                        ELExpression resolvedToken = parentVar.getResolvedElToken();
                        if (resolvedToken == null && parentVar.getElToken() != null) {
                            try {
                                this.engine.resolveELOperand(this.file, var.getElToken(), true, parentVars, this);
                                resolvedToken = parentVar.getResolvedElToken();
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                ELCorePlugin.getPluginLog().logError((Throwable)e);
                            }
                            catch (BadLocationException e) {
                                ELCorePlugin.getPluginLog().logError((Throwable)e);
                            }
                        }
                        if (resolvedToken != null) {
                            String newValue;
                            String oldText = var.getElToken().getText();
                            var.value = newValue = "#{" + resolvedToken.getText() + oldText.substring(parentVar.getName().length()) + "}";
                            var.elToken = var.parseEl(newValue);
                        }
                    }
                    return var;
                }
                parentVars.add(var);
            }
        }
        return null;
    }
}

