/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.Tokenizer;
import org.jboss.tools.common.el.internal.core.parser.token.ConstantTokenDescription;
import org.jboss.tools.common.el.internal.core.parser.token.InstanceofTokenDescription;
import org.jboss.tools.common.el.internal.core.parser.token.OperationTokenDescription;

public class JavaNameTokenDescription
implements ITokenDescription {
    public static final int JAVA_NAME = 3;
    public static JavaNameTokenDescription INSTANCE = new JavaNameTokenDescription();
    public static ConstantTokenDescription INSTANCEOF_INSTANCE = InstanceofTokenDescription.INSTANCE;

    public String getName() {
        return ElCoreMessages.JavaNameTokenDescription_Name;
    }

    public int getType() {
        return 3;
    }

    public boolean isStart(Tokenizer tokenizer, int offset) {
        if (OperationTokenDescription.INSTANCE.isStart(tokenizer, offset)) {
            return false;
        }
        if (InstanceofTokenDescription.INSTANCE.isStart(tokenizer, offset)) {
            return false;
        }
        char ch = tokenizer.lookUpChar(offset);
        return Character.isJavaIdentifierStart(ch) && ch != '\u0000' && ch != '$';
    }

    public boolean read(Tokenizer tokenizer, int offset) {
        int i = offset;
        char ch = '\u0000';
        while (Character.isJavaIdentifierPart(ch = tokenizer.readNextChar()) && ch != '\u0000') {
            ++i;
        }
        if (ch != '\u0000') {
            tokenizer.releaseChar();
        }
        tokenizer.addToken(this.getType(), offset, i);
        return false;
    }
}

