/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.ITokenDescription;
import org.jboss.tools.common.el.core.parser.Tokenizer;

public class WhiteSpaceTokenDescription
implements ITokenDescription {
    public static final int WHITESPACE = 0;
    public static WhiteSpaceTokenDescription INSTANCE = new WhiteSpaceTokenDescription();

    public String getName() {
        return ElCoreMessages.WhiteSpaceTokenDescription_Name;
    }

    public int getType() {
        return 0;
    }

    public boolean isStart(Tokenizer tokenizer, int offset) {
        char i = tokenizer.lookUpChar(offset);
        return Character.isWhitespace(i);
    }

    public boolean read(Tokenizer tokenizer, int offset) {
        int i = offset;
        char ch = '\u0000';
        while (Character.isWhitespace(ch = tokenizer.readNextChar())) {
            ++i;
        }
        if (ch != '\u0000') {
            tokenizer.releaseChar();
        }
        tokenizer.addToken(this.getType(), offset, i);
        return false;
    }
}

