/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.adopt;

import java.util.Enumeration;
import java.util.HashSet;
import org.jboss.tools.jsf.ui.adopt.JSPTokenizer;
import org.jboss.tools.jsf.ui.adopt.Token;

public class JSPAdoptHelper {
    public static final String JSF_CORE_TAGLIB_URI = "http://java.sun.com/jsf/core";
    public static final String JSF_CORE_TAGLIB_PREFIX_DEFAULT = "f";
    public static final String JSF_HTML_TAGLIB_URI = "http://java.sun.com/jsf/html";
    public static final String JSF_HTML_TAGLIB_PREFIX_DEFAULT = "h";

    public static String getPrefixForURI(Token root, String uri, String defaultValue) {
        String p = JSPAdoptHelper.getPrefixForURI(root, uri);
        if (p == null || p.length() == 0) {
            p = JSPAdoptHelper.getPrefixForURIFromXMLNS(root, uri);
        }
        return p == null || p.length() == 0 ? defaultValue : p;
    }

    public static String getPrefixForURI(Token root, String uri) {
        Token t = root.firstChild;
        while (t != null) {
            if (t.kind == JSPTokenizer.DIRECTIVE && "taglib".equals(t.name) && t.attributes != null && uri.equalsIgnoreCase(t.attributes.getProperty("uri"))) {
                String prefix = t.attributes.getProperty("prefix");
                return prefix == null ? "?" : prefix;
            }
            t = t.nextSibling;
        }
        return null;
    }

    public static String getPrefixForURIFromXMLNS(Token root, String uri) {
        Token t = root.firstChild;
        while (t != null) {
            if (t.kind == JSPTokenizer.TAG && "jsp:root".equals(t.name) && t.attributes != null) {
                Enumeration<Object> names = t.attributes.keys();
                while (names != null && names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = (String)t.attributes.get(name);
                    if (value == null || !value.equals(uri) || !name.startsWith("xmlns:")) continue;
                    String prefix = name.substring("xmlns:".length());
                    return prefix == null ? "?" : prefix;
                }
            } else {
                String prefix = JSPAdoptHelper.getPrefixForURIFromXMLNS(t, uri);
                if (prefix != null && prefix.length() > 0) {
                    return prefix;
                }
            }
            t = t.nextSibling;
        }
        return null;
    }

    public static String getLoadedBundleVar(Token root, String jsfCorePrefix, String baseName) {
        if (root == null || jsfCorePrefix == null || jsfCorePrefix.length() == 0 || baseName == null || baseName.length() == 0) {
            return null;
        }
        String tagName = String.valueOf(jsfCorePrefix) + ":loadBundle";
        Token t = root.firstChild;
        while (t != null) {
            String v;
            if (t.kind == JSPTokenizer.TAG && tagName.equals(t.name) && t.attributes != null) {
                if (baseName.equals(t.attributes.getProperty("basename"))) {
                    v = t.attributes.getProperty("var");
                    return v == null ? "?" : v;
                }
            } else {
                v = JSPAdoptHelper.getLoadedBundleVar(t, jsfCorePrefix, baseName);
                if (v != null && v.length() > 0) {
                    return v;
                }
            }
            t = t.nextSibling;
        }
        return null;
    }

    public static int getPositionForBundle(Token root, String jsfCorePrefix) {
        JSPAdoptHelper.isXHTML(root);
        return JSPAdoptHelper.getPositionForBundle(root, jsfCorePrefix, 0);
    }

    public static boolean isXHTML(Token root) {
        return root.firstChild != null && root.firstChild.kind == JSPTokenizer.DOCTYPE && root.firstChild.attributes.getProperty("public") != null && root.firstChild.attributes.getProperty("public").startsWith("-//W3C//DTD XHTML");
    }

    private static int getPositionForBundle(Token root, String jsfCorePrefix, int off) {
        int q = off;
        Token t = root.firstChild;
        while (t != null) {
            if (t.kind == JSPTokenizer.TAG) {
                if (t.name.equals("jsp:root")) {
                    q = t.off + t.length;
                    return JSPAdoptHelper.getPositionForBundle(t, jsfCorePrefix, q);
                }
                if (t.name.equalsIgnoreCase("html")) {
                    if (JSPAdoptHelper.isXHTML(root)) {
                        return t.off + t.length;
                    }
                    return q;
                }
                if (t.name.equals(String.valueOf(jsfCorePrefix) + ":loadBundle")) {
                    q = t.off + t.length;
                }
            } else if (t.kind == JSPTokenizer.DIRECTIVE) {
                if (t.name.equals("include")) {
                    return q;
                }
                q = t.off + t.length;
            }
            t = t.nextSibling;
        }
        return q;
    }

    public static String getNameForNewBundle(Token root, String jsfCorePrefix) {
        String n = String.valueOf(jsfCorePrefix) + ":loadBundle";
        HashSet<String> set = new HashSet<String>();
        Token t = root.firstChild;
        while (t != null) {
            String v;
            if (t.kind == JSPTokenizer.TAG && t.name.equals(n) && t.attributes != null && (v = t.attributes.getProperty("var")) != null) {
                set.add(v);
            }
            t = t.nextSibling;
        }
        String v = "msg";
        if (set.contains(v)) {
            int i = 1;
            while (set.contains(String.valueOf(v) + i)) {
                ++i;
            }
            v = String.valueOf(v) + i;
        }
        return v;
    }

    public static String cutOffQuotes(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(text);
        boolean doCutOff = false;
        if (buffer.charAt(0) == '\"' && buffer.charAt(buffer.length() - 1) == '\"') {
            doCutOff = true;
        }
        if (buffer.charAt(0) == '\'' && buffer.charAt(buffer.length() - 1) == '\'') {
            doCutOff = true;
        }
        return doCutOff ? buffer.substring(1, buffer.length() - 1).toString() : text;
    }
}

