/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.adopt;

import java.util.Properties;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.jsf.ui.adopt.Token;

public class JSPTokenizer {
    static int ROOT = 0;
    static int TEXT = 1;
    static int TAG = 2;
    static int TAG_CLOSING = 3;
    static int JSP = 4;
    static int DIRECTIVE = 5;
    static int COMMENT = 6;
    static int DOCTYPE = 7;
    String text;
    StringBuffer sb = new StringBuffer();
    Token root;
    int selectionStart;
    int selectionEnd;
    int start = -1;
    int end = -1;

    public Token parse(IDocument document) {
        this.selectionStart = 0;
        this.selectionEnd = document.getLength();
        this.text = document.get();
        this.root = new Token(ROOT, "", 0, this.text.length(), null);
        this.root.indent = "";
        this.root.indentLevel = -1;
        this.tokenize();
        return this.root;
    }

    private void tokenize() {
        int cursor = 0;
        Token current = this.root;
        Token last = null;
        while (cursor < this.text.length()) {
            int nc;
            int nc2;
            int q;
            int p = this.text.indexOf(60, cursor);
            if (p < 0) {
                last = this.createTag(TEXT, "", cursor, this.text.length() - cursor, last);
                current.addChild(last);
                cursor = this.text.length();
                continue;
            }
            if (p > cursor) {
                last = this.createTag(TEXT, "", cursor, p - cursor, last);
                current.addChild(last);
                cursor = p;
            }
            if (this.isStringStart(cursor, "<!DOCTYPE")) {
                int l = "<!DOCTYPE".length();
                q = this.text.indexOf(">", cursor);
                nc2 = q < 0 ? this.text.length() : q + 1;
                int k = this.skipToName(cursor + l, nc2);
                String tag = this.readTag(cursor + l + k);
                last = this.createTag(DOCTYPE, tag, cursor, nc2 - cursor, last);
                current.addChild(last);
                int ab = cursor + l + k + tag.length();
                int al = nc2 - ab;
                last.attributes = JSPTokenizer.getDoctype(this.text, ab, al);
                cursor = nc2;
                continue;
            }
            if (this.isStringStart(cursor, "<%@")) {
                int q2 = this.text.indexOf("%>", cursor);
                nc = q2 < 0 ? this.text.length() : q2 + 2;
                int k = this.skipToName(cursor + 3, nc);
                String tag = this.readTag(cursor + 3 + k);
                last = this.createTag(DIRECTIVE, tag, cursor, nc - cursor, last);
                current.addChild(last);
                int ab = cursor + 3 + k + tag.length();
                int al = nc - ab;
                last.attributes = JSPTokenizer.getAttributes(this.text, ab, al);
                cursor = nc;
                continue;
            }
            if (this.isStringStart(cursor, "<%")) {
                int q3 = this.text.indexOf("%>", cursor);
                nc = q3 < 0 ? this.text.length() : q3 + 2;
                last = this.createTag(JSP, "", cursor, nc - cursor, last);
                current.addChild(last);
                cursor = nc;
                continue;
            }
            if (this.isStringStart(cursor, "<!--")) {
                int q4 = this.text.indexOf("-->", cursor);
                nc = q4 < 0 ? this.text.length() : q4 + 3;
                last = this.createTag(COMMENT, "", cursor, nc - cursor, last);
                current.addChild(last);
                cursor = nc;
                continue;
            }
            if (this.isStringStart(cursor, "<!")) {
                int q5 = this.text.indexOf(">", cursor);
                nc = q5 < 0 ? this.text.length() : q5 + 1;
                last = this.createTag(COMMENT, "", cursor, nc - cursor, last);
                current.addChild(last);
                cursor = nc;
                continue;
            }
            if (this.isStringStart(cursor, "</")) {
                String tag = this.readTag(cursor + 2);
                q = this.text.indexOf(">", cursor);
                nc2 = q < 0 ? this.text.length() : q + 1;
                last = this.createTag(TAG_CLOSING, tag, cursor, nc2 - cursor, last);
                current = this.findParent(current, last);
                current.addChild(last);
                cursor = nc2;
                continue;
            }
            String tag = this.readTag(cursor + 1);
            q = this.findTagClosingSymbol(cursor);
            nc2 = q < 0 ? this.text.length() : q + 1;
            last = this.createTag(TAG, tag, cursor, nc2 - cursor, last);
            int ab = cursor + 1 + tag.length();
            int al = nc2 - ab;
            last.attributes = JSPTokenizer.getAttributes(this.text, ab, al);
            if (this.isOptionallyClosed(tag)) {
                current = this.findParentForOptionallyClosedTag(current, tag);
            }
            current.addChild(last);
            cursor = nc2;
            if (q <= 0 || this.text.charAt(q - 1) == '/' || !this.areChildrenAllowed(tag)) continue;
            current = last;
        }
    }

    private Token findParent(Token current, Token t) {
        Token c = current;
        while (c.kind != ROOT) {
            if (c.name.equals(t.name)) {
                return c.parent;
            }
            c = c.parent;
        }
        return current;
    }

    private boolean isOptionallyClosed(String name) {
        return ".body.p.dt.dd.li.ol.option.thead.tfoot.tbody.colgroup.tr.td.th.head.html.".indexOf(name.toLowerCase()) >= 0;
    }

    private Token findParentForOptionallyClosedTag(Token current, String name) {
        String n1 = name.toLowerCase();
        String n2 = current.name.toLowerCase();
        if ("p".equals(n1)) {
            if (n2.equals("p")) {
                return current.parent;
            }
        } else if ("tr".equals(n1)) {
            if (n2.equals("tr")) {
                return current.parent;
            }
            if (n2.equals("th") || n2.equals("td") || n2.equals("p")) {
                return this.findParentForOptionallyClosedTag(current.parent, name);
            }
        } else if ("td".equals(n1) || "th".equals(n1)) {
            if (n2.equals("th") || n2.equals("td")) {
                return current.parent;
            }
            if (n2.equals("p")) {
                return this.findParentForOptionallyClosedTag(current.parent, name);
            }
        }
        return current;
    }

    private boolean areChildrenAllowed(String name) {
        return ".br.area.link.img.param.hr.input.col.isindex.base.meta.".indexOf("." + name.toLowerCase() + ".") < 0;
    }

    private Token createTag(int kind, String name, int off, int length, Token previous) {
        Token t = new Token(kind, name, off, length, previous);
        int n = t.indentLength = kind == TEXT ? -1 : this.computeIndentLength(off);
        if (previous != null && previous.kind == TEXT && t.indentLength > 0) {
            previous.length -= t.indentLength;
            t.off -= t.indentLength;
            t.length += t.indentLength;
        }
        return t;
    }

    private boolean isStringStart(int c, String s) {
        if (this.text.length() <= c + s.length()) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (this.text.charAt(c + i) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int skipToName(int b, int e) {
        int t = b;
        while (t < e && !this.isNameChar(this.text.charAt(t))) {
            ++t;
        }
        return t - b;
    }

    private String readTag(int c) {
        int k = c;
        while (k < this.text.length() && this.isNameChar(this.text.charAt(k))) {
            ++k;
        }
        return this.text.substring(c, k);
    }

    private boolean isNameChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '-' || ch == ':';
    }

    private int computeIndentLength(int off) {
        --off;
        int l = 0;
        while (off >= 0) {
            char ch = this.text.charAt(off);
            if (ch == '\n' || ch == '\r') {
                return l;
            }
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            ++l;
            --off;
        }
        return off < 0 ? l : -1;
    }

    public int findTagClosingSymbol(int i) {
        int l = this.text.length();
        char quota = '\u0000';
        while (i < l) {
            char ch = this.text.charAt(i);
            if (quota != '\u0000') {
                if (ch == quota) {
                    quota = '\u0000';
                }
            } else if (ch == '\'' || ch == '\"') {
                quota = ch;
            } else if (ch == '>') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Token getTokenAt(int pos) {
        return this.getTokenAt(this.root, pos);
    }

    public Token getTokenAt(Token t, int pos) {
        if (t == null || t.off > pos) {
            return null;
        }
        if (t.off + t.length > pos) {
            return t.firstChild == null || t.firstChild.off > pos ? t : this.getTokenAt(t.firstChild, pos);
        }
        if (t.nextSibling != null && t.nextSibling.off <= pos) {
            return this.getTokenAt(t.nextSibling, pos);
        }
        return t.firstChild == null ? t : this.getTokenAt(t.firstChild, pos);
    }

    public boolean isInTagAttributeValue(int pos) {
        Token t = this.getTokenAt(this.root, pos);
        if (t == null || t.kind != TAG) {
            return false;
        }
        char quote = '\u0000';
        int i = this.root.off;
        while (i < this.text.length() && i < pos) {
            char ch = this.text.charAt(i);
            if (ch == quote) {
                quote = '\u0000';
            } else if (ch == '\"' || ch == '\'') {
                quote = ch;
            }
            ++i;
        }
        return quote != '\u0000';
    }

    static Properties getAttributes(String text, int off, int length) {
        Properties p = new Properties();
        int NOTHING = 0;
        int NAME = 1;
        int VALUE = 2;
        int state = 0;
        char quote = '\u0000';
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i + off);
            if (state == NOTHING) {
                if (" \t\r\n".indexOf(ch) < 0) {
                    if ("/\\><%".indexOf(ch) >= 0) break;
                    state = NAME;
                    name.append(ch);
                }
            } else if (state == NAME) {
                if (ch == '=') {
                    state = VALUE;
                } else {
                    name.append(ch);
                }
            } else if (state == VALUE) {
                if (ch == quote) {
                    String n = name.toString().trim();
                    String v = value.toString();
                    name.setLength(0);
                    value.setLength(0);
                    p.setProperty(n, v);
                    state = NOTHING;
                    quote = '\u0000';
                } else if (quote == '\u0000' && (ch == '\"' || ch == '\'')) {
                    quote = ch;
                } else if (quote != '\u0000') {
                    value.append(ch);
                }
            }
            ++i;
        }
        return p;
    }

    static Properties getDoctype(String text, int off, int length) {
        int i2;
        int i1;
        Properties p = new Properties();
        int b = off;
        int i = text.indexOf("PUBLIC", off);
        if (i >= 0 && (i1 = text.indexOf(34, i)) >= 0 && (i2 = text.indexOf(34, i1 + 1)) >= 0) {
            p.setProperty("public", text.substring(i1 + 1, i2));
            b = i2 + 1;
        }
        if ((i1 = text.indexOf(34, b)) >= 0 && (i2 = text.indexOf(34, i1 + 1)) >= 0) {
            p.setProperty("system", text.substring(i1 + 1, i2));
        }
        return p;
    }
}

