/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.jboss.tools.jsf.ui.editor.dnd.DndHelper;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFElementEditPolicy;
import org.jboss.tools.jsf.ui.editor.edit.LinkEditPart;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.commands.ReconnectSourceLinkCommand;
import org.jboss.tools.jsf.ui.editor.model.commands.ReconnectSourceLinkCommand2;
import org.jboss.tools.jsf.ui.editor.model.commands.ReconnectTargetLinkCommand;

public class GroupEditPolicy
extends JSFElementEditPolicy {
    private GroupEditPart getGroupEditPart() {
        return (GroupEditPart)this.getHost();
    }

    public Command getCommand(Request request) {
        if ("connection end".equals(request.getType())) {
            return this.getConnectionEndCommand();
        }
        if ("Reconnection source".equals(request.getType())) {
            if (((GroupEditPart)this.getHost()).isSingle()) {
                return this.getReconnectionSourceCommand((ReconnectRequest)request);
            }
        } else if ("Reconnection target".equals(request.getType())) {
            return this.getReconnectionTargetCommand((ReconnectRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getConnectionEndCommand() {
        if (!DndHelper.isDropEnabled(this.getGroupEditPart().getGroupModel().getSource())) {
            return null;
        }
        ConnectionEndCommand command = new ConnectionEndCommand();
        command.setChild(this.getGroupEditPart().getGroupModel());
        return command;
    }

    protected Command getReconnectionSourceCommand(ReconnectRequest request) {
        ReconnectSourceLinkCommand command = new ReconnectSourceLinkCommand();
        ConnectionAnchor ctor = this.getGroupEditPart().getSourceConnectionAnchor((Request)request);
        List list = this.getGroupEditPart().getSourceConnections();
        int i = 0;
        while (i < list.size()) {
            LinkEditPart part = (LinkEditPart)list.get(i);
            if (!part.equals(request.getConnectionEditPart()) && part != null && part.getConnectionFigure().getSourceAnchor().equals(ctor)) {
                command.setLink(part.getLink());
                if (command.canExecute()) {
                    return command;
                }
            }
            ++i;
        }
        ReconnectSourceLinkCommand2 command2 = new ReconnectSourceLinkCommand2();
        command2.setGroup(this.getGroupEditPart().getGroupModel());
        return command2;
    }

    protected Command getReconnectionTargetCommand(ReconnectRequest request) {
        ReconnectTargetLinkCommand command = new ReconnectTargetLinkCommand();
        command.setChild(this.getGroupEditPart().getGroupModel());
        return command;
    }

    static class ConnectionEndCommand
    extends Command {
        IGroup child = null;

        public ConnectionEndCommand() {
            super("ConnectionEndCommand");
        }

        public void setChild(IGroup child) {
            this.child = child;
        }

        public void execute() {
        }

        public boolean canUndo() {
            return false;
        }
    }
}

