/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.MouseEvent;
import org.jboss.tools.jsf.ui.editor.dnd.DndHelper;
import org.jboss.tools.jsf.ui.editor.edit.JSFConnectionHandle;
import org.jboss.tools.jsf.ui.editor.figures.FigureFactory;
import org.jboss.tools.jsf.ui.editor.model.ILink;

public class LinkEndpointEditPolicy
extends ConnectionEndpointEditPolicy {
    private List JSFhandles = null;

    private void addJSFHandles() {
        this.removeJSFHandles();
        this.JSFhandles = this.createJSFHandles();
        IFigure layer = this.getLayer("Handle Layer");
        int i = 0;
        while (i < this.JSFhandles.size()) {
            layer.add((IFigure)this.JSFhandles.get(i));
            ++i;
        }
    }

    private void removeJSFHandles() {
        if (this.JSFhandles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        int i = 0;
        while (i < this.JSFhandles.size()) {
            layer.remove((IFigure)this.JSFhandles.get(i));
            ++i;
        }
        this.JSFhandles = null;
    }

    protected void addSelectionHandles() {
        super.addSelectionHandles();
        this.addJSFHandles();
        this.getConnectionFigure().setForegroundColor(FigureFactory.selectedColor);
    }

    protected PolylineConnection getConnectionFigure() {
        return (PolylineConnection)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected void removeSelectionHandles() {
        super.removeSelectionHandles();
        this.removeJSFHandles();
        this.getConnectionFigure().setForegroundColor(FigureFactory.normalColor);
    }

    protected List createSelectionHandles() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        list.add(new LinkEndHandle((ConnectionEditPart)this.getHost()));
        list.add(new LinkStartHandle((ConnectionEditPart)this.getHost()));
        return list;
    }

    protected List createJSFHandles() {
        ArrayList<JSFConnectionHandle> list = new ArrayList<JSFConnectionHandle>();
        PolylineConnection conn = this.getConnectionFigure();
        boolean flag = true;
        int i = 0;
        while (i < conn.getPoints().size() - 3) {
            flag = !flag;
            list.add(new JSFConnectionHandle((ConnectionEditPart)this.getHost(), flag, i + 1));
            ++i;
        }
        return list;
    }

    class LinkEndHandle
    extends ConnectionHandle {
        public LinkEndHandle(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public LinkEndHandle(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public LinkEndHandle() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            LinkEndpointTracker tracker = new LinkEndpointTracker((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection target");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }

    class LinkEndpointTracker
    extends ConnectionEndpointTracker {
        public LinkEndpointTracker(ConnectionEditPart cpart) {
            super(cpart);
        }

        public void mouseDown(MouseEvent me, EditPartViewer epv) {
            super.mouseDown(me, epv);
            LinkEndpointEditPolicy.this.removeJSFHandles();
            DndHelper.drag(((ILink)LinkEndpointEditPolicy.this.getHost().getModel()).getSource());
        }

        public void mouseUp(MouseEvent me, EditPartViewer epv) {
            super.mouseUp(me, epv);
            if (LinkEndpointEditPolicy.this.getHost().getSelected() != 0) {
                LinkEndpointEditPolicy.this.addJSFHandles();
            }
        }

        protected boolean handleNativeDragFinished(DragSourceEvent event) {
            DndHelper.dragEnd();
            return false;
        }
    }

    class LinkStartHandle
    extends ConnectionHandle {
        public LinkStartHandle(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public LinkStartHandle(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public LinkStartHandle() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            LinkEndpointTracker tracker = new LinkEndpointTracker((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection source");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

