/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.form;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.XChildrenTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkLineFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.FacesConfigEditorMessages;

public class ApplicationConfigForm
extends ExpandableForm {
    private XAttributeSupport support;
    private XModelObject xmo;
    private ChildTable messageBundleTable;
    private ChildTable resourceBundleTable;
    private IWidgetSettings settings = new WhiteSettings();
    private long timeStamp = -1L;

    public ApplicationConfigForm() {
        this.support = new XAttributeSupport(this.settings);
        this.setCollapsable(Boolean.TRUE);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.messageBundleTable != null) {
            this.messageBundleTable.dispose();
            this.messageBundleTable = null;
        }
        if (this.resourceBundleTable != null) {
            this.resourceBundleTable.dispose();
            this.resourceBundleTable = null;
        }
    }

    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        Composite composite = new Composite(parent, 0);
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        String description = FacesConfigEditorMessages.APPLICATIONCONFIGFORM_DESCRIPTION;
        if (description != null && description.length() > 0) {
            Label label = new Label(composite, 64);
            settings.setupControl((Control)label);
            label.setText(description);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        String[] attributes = new String[]{"action-listener", "navigation-handler", "view-handler", "state-manager"};
        if (this.xmo == null) {
            return composite;
        }
        int i = 0;
        while (i < attributes.length) {
            IPropertyEditor editor = this.support.getPropertyEditorByName(attributes[i]);
            this.putFieldEditorInToComposit(composite, editor);
            ++i;
        }
        IPropertyEditor editor = this.support.getPropertyEditorByName("default-render-kit-id");
        ExtendedFieldEditor f = editor.getFieldEditor(composite);
        f.fillIntoGrid(composite, 2);
        this.support.registerFieldEditor(editor.getAttributeName(), (FieldEditor)f);
        if (this.messageBundleTable != null) {
            this.messageBundleTable.fill(composite);
        }
        if (this.resourceBundleTable != null) {
            this.resourceBundleTable.fill(composite);
        }
        return composite;
    }

    private void putFieldEditorInToComposit(Composite composite, IPropertyEditor propertyEditor) {
        if (propertyEditor != null) {
            JavaHyperlinkLineFieldEditor sb = new JavaHyperlinkLineFieldEditor(this.settings);
            sb.setLabelText(propertyEditor.getLabelText());
            sb.setPropertyEditor(propertyEditor);
            sb.fillIntoGrid(composite, 2);
            this.support.registerFieldEditor(propertyEditor.getAttributeName(), (FieldEditor)sb);
        }
    }

    public void initialize(Object model) {
        this.setHeadingText(FacesConfigEditorMessages.APPLICATIONCONFIGFORM_HEADER);
        if (model == null) {
            JsfUiPlugin.getPluginLog().logInfo("Error to create form " + FacesConfigEditorMessages.APPLICATIONCONFIGFORM_HEADER + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        this.xmo = ((XModelObject)model).getChildByPath("application");
        if (this.xmo == null) {
            JsfUiPlugin.getPluginLog().logInfo("Error to create form " + FacesConfigEditorMessages.APPLICATIONCONFIGFORM_HEADER + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        this.support.init(this.xmo);
        this.support.setAutoStore(Boolean.TRUE.booleanValue());
        this.messageBundleTable = new ChildTable();
        this.messageBundleTable.create("JSFMessageBundle", new String[]{"message-bundle"}, new String[]{FacesConfigEditorMessages.APPLICATIONCONFIGFORM_MESSAGEBUNDLE_COLUMN_LABEL}, new int[]{100}, "CreateActions.AddMessageBundle");
        if (this.xmo.getModelEntity().getChild("JSFResourceBundle") != null) {
            this.resourceBundleTable = new ChildTable();
            this.resourceBundleTable.create("JSFResourceBundle", new String[]{"base-name", "var"}, new String[]{"Resource Bundle", "Var"}, new int[]{70, 30}, "CreateActions.AddResourceBundle");
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.support != null) {
            this.support.updateEnablementByModelObject();
        }
    }

    public void update() {
        long ts;
        long l = ts = this.xmo == null ? -1L : this.xmo.getTimeStamp();
        if (ts == this.timeStamp) {
            return;
        }
        this.timeStamp = ts;
        if (this.support != null) {
            this.support.load();
        }
    }

    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }

    class ChildTable {
        private TableStructuredEditor tableEditor;
        private XChildrenTableStructuredAdapter tableAdapter;

        ChildTable() {
        }

        void dispose() {
            if (this.tableEditor != null) {
                this.tableEditor.dispose();
            }
            this.tableEditor = null;
            if (this.tableAdapter != null) {
                this.tableAdapter.dispose();
            }
            this.tableAdapter = null;
        }

        public void create(String childEntity, String[] attributes, String[] attributeLabels, int[] widths, String createActionPath) {
            this.tableAdapter = new XChildrenTableStructuredAdapter();
            this.tableAdapter.setShownEntities(new String[]{childEntity});
            this.tableAdapter.getActionMapping().clear();
            this.tableAdapter.getActionMapping().put("ADD_ACTION", createActionPath);
            this.tableAdapter.getActionMapping().put("REMOVE_ACTION", "DeleteActions.Delete");
            this.tableAdapter.getActionMapping().put("EDIT_ACTION", "Properties.Properties");
            this.tableAdapter.getActionMapping().put("UP_ACTION", "%internal%");
            this.tableAdapter.getActionMapping().put("DOWN_ACTION", "%internal%");
            this.tableAdapter.setShownProperties(attributes);
            this.tableAdapter.setColumnLabels(attributeLabels);
            this.tableAdapter.setWidths(widths);
            this.tableAdapter.setModelObject(ApplicationConfigForm.this.xmo);
            this.tableEditor = new TableStructuredEditor(ApplicationConfigForm.this.settings);
            this.tableEditor.setLabelText("");
            this.tableEditor.setInput((Object)this.tableAdapter);
        }

        void fill(Composite composite) {
            Control[] control = ((IFieldEditor)this.tableEditor.getFieldEditor(composite)).getControls(composite);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            control[1].setLayoutData((Object)gd);
        }
    }
}

