/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.form;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.FacesConfigEditorMessages;

public class ManagedBeanPropertyForm
extends ExpandableForm {
    private XAttributeSupport support;
    private XModelObject xmo;
    private IWidgetSettings settings = new WhiteSettings();
    private Composite switchComposite;
    private Control anyLabel;
    private static final String PROPERTY_NAME = "property-name";
    private static final String PROPERTY_CLASS = "property-class";
    private static final String VALUE_KIND = "value-kind";
    private static final String VALUE_NAME = "value";
    private static final String NULL_VALUE_NAME = "null-value";
    private static final String LIST_ENTRIES_NAME = "list-entries";
    private static final String MAP_ENTRIES_NAME = "map-entries";
    private static final String[] TAGS = new String[]{"value", "null-value", "list-entries", "map-entries"};
    private static final String VALUE_ACTION = "CreateActions.ChangeToValue";
    private static final String NULL_VALUE_ACTION = "CreateActions.AddNullValue";
    private static final String LIST_VALUE_ACTION = "CreateActions.ChangeToList";
    private static final String MAP_VALUE_ACTION = "CreateActions.ChangeToMap";
    private static final String[] ACTIONS = new String[]{"CreateActions.ChangeToValue", "CreateActions.AddNullValue", "CreateActions.ChangeToList", "CreateActions.ChangeToMap"};
    private boolean localChange = Boolean.FALSE;
    private ComboField comboField = new ComboField();
    private ValueControl valueControl = new ValueControl();

    public ManagedBeanPropertyForm() {
        this.support = new XAttributeSupport(this.settings);
        this.setCollapsable(Boolean.TRUE);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.switchComposite != null && !this.switchComposite.isDisposed()) {
            this.switchComposite.dispose();
        }
        this.switchComposite = null;
        if (this.anyLabel != null && !this.anyLabel.isDisposed()) {
            this.anyLabel.dispose();
        }
        this.anyLabel = null;
        if (this.comboField != null) {
            this.comboField.dispose();
        }
        this.comboField = null;
        if (this.valueControl != null) {
            this.valueControl.dispose();
        }
        this.valueControl = null;
    }

    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        String description = FacesConfigEditorMessages.MANAGEDBEANPROPERTYFORM_DESCRIPTION;
        if (description != null && description.length() > 0) {
            Label label = new Label(composite, 64);
            settings.setupControl((Control)label);
            label.setText(description);
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        if (this.xmo == null) {
            return composite;
        }
        List editors = this.support.getEditorList();
        for (PropertyEditor propertyEditor : editors) {
            Control[] controls;
            if (PROPERTY_NAME.equals(propertyEditor.getAttributeName()) && (controls = this.support.fillComposite(composite, propertyEditor, null)) != null) {
                this.anyLabel = controls[0];
            }
            if (!PROPERTY_CLASS.equals(propertyEditor.getAttributeName())) continue;
            IPropertyFieldEditor wraper = (IPropertyFieldEditor)propertyEditor.getFieldEditor(composite);
            ExtendedFieldEditor fe = (ExtendedFieldEditor)wraper;
            fe.setLabelText(propertyEditor.getLabelText());
            wraper.setPropertyEditor((IPropertyEditor)propertyEditor);
            fe.fillIntoGrid(composite, 2);
            fe.setEnabled(this.xmo.isAttributeEditable(propertyEditor.getAttributeName()));
            this.support.registerFieldEditor(propertyEditor.getAttributeName(), (FieldEditor)((ExtendedFieldEditor)wraper));
            this.anyLabel = fe.getLabelComposite(composite);
        }
        this.comboField.createControls(composite);
        this.switchComposite = new Composite(composite, 0);
        this.switchComposite.setBackground(composite.getBackground());
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.switchComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.switchComposite.setLayoutData((Object)gd);
        this.switchComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 11 && ManagedBeanPropertyForm.this.valueControl.getControl() != null) {
                    GridData gd = new GridData();
                    gd.widthHint = ((ManagedBeanPropertyForm)ManagedBeanPropertyForm.this).anyLabel.getSize().x;
                    ManagedBeanPropertyForm.this.valueControl.setLabelLayoutData(gd);
                }
            }
        });
        this.valueControl.setParent(this.switchComposite);
        int index = this.getSelectedIndex();
        if (index != -1) {
            this.valueControl.activate();
            gd = new GridData(768);
            if (this.valueControl.getControl() != null) {
                this.valueControl.getControl().setLayoutData((Object)gd);
            }
        }
        editors = this.support.getEditorList();
        Iterator i = editors.iterator();
        return composite;
    }

    private String getSelectedValueKind() {
        if (this.xmo != null) {
            int index = this.getIndex(TAGS, this.xmo.getAttributeValue(VALUE_KIND));
            if (index == -1) {
                return "";
            }
            return TAGS[index];
        }
        return "";
    }

    public void update() {
        if (this.support == null) {
            return;
        }
        this.support.load();
        this.comboField._update();
        this.valueControl.update();
    }

    private int getIndex(String[] array, String object) {
        int i = 0;
        while (i < array.length) {
            if (object.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSelectedIndex() {
        return this.getIndex(TAGS, this.getSelectedValueKind());
    }

    private void doComboModifyText() {
        this.localChange = Boolean.TRUE;
        int index = Arrays.asList(TAGS).indexOf(this.comboField.combo.getText());
        XActionInvoker.invoke((String)ACTIONS[index], (XModelObject)this.xmo, null, (Properties)new Properties());
        this.comboField.combo.setText(this.getSelectedValueKind());
        this.localChange = Boolean.FALSE;
        if (index != -1) {
            this.valueControl.update();
            this.valueControl.activate();
            if (this.valueControl.getControl() != null) {
                this.valueControl.getControl().setLayoutData((Object)new GridData(768));
            }
        }
    }

    public void initialize(Object model) {
        this.setHeadingText(FacesConfigEditorMessages.MANAGEDBEANPROPERTYFORM_HEADER);
        this.xmo = (XModelObject)model;
        if (this.xmo == null) {
            JsfUiPlugin.getPluginLog().logInfo("Error to create form " + FacesConfigEditorMessages.MANAGEDBEANPROPERTYFORM_HEADER + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        model = this.xmo.getModel();
        this.support.init(this.xmo);
        this.valueControl.init(this.xmo);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.support != null) {
            this.support.setEnabled(enabled);
            this.support.updateEnablementByModelObject();
            this.comboField._updateEnablement();
        }
    }

    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }

    class ComboField {
        private Label vklabel;
        private Combo combo;

        ComboField() {
        }

        public void createControls(Composite composite) {
            this.vklabel = new Label(composite, 0);
            this.vklabel.setText("Value Kind:");
            this.vklabel.setBackground(composite.getBackground());
            ManagedBeanPropertyForm.this.settings.setupControl((Control)this.vklabel);
            BorderedControl border = new BorderedControl(composite, 0, ManagedBeanPropertyForm.this.settings.getBorder("Combo.Border"));
            this.combo = new Combo((Composite)border, 0x800008);
            this.combo.setItems(TAGS);
            this.combo.setText(ManagedBeanPropertyForm.this.getSelectedValueKind());
            this.combo.setBackground(ManagedBeanPropertyForm.this.settings.getColor("Combo.Background"));
            this.combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!ManagedBeanPropertyForm.this.localChange) {
                        ManagedBeanPropertyForm.this.doComboModifyText();
                    }
                }
            });
            border.setLayoutData((Object)new GridData(768));
        }

        public void dispose() {
            if (this.vklabel != null && !this.vklabel.isDisposed()) {
                this.vklabel.dispose();
            }
            this.vklabel = null;
            if (this.combo != null && !this.combo.isDisposed()) {
                this.combo.dispose();
            }
            this.combo = null;
        }

        public void _update() {
            if (this.combo != null && !this.combo.isDisposed()) {
                ManagedBeanPropertyForm.this.localChange = true;
                this.combo.setText(ManagedBeanPropertyForm.this.getSelectedValueKind());
                ManagedBeanPropertyForm.this.localChange = false;
            }
        }

        public void _updateEnablement() {
            if (this.combo != null && !this.combo.isDisposed()) {
                boolean e = ManagedBeanPropertyForm.this.xmo != null && ManagedBeanPropertyForm.this.xmo.isAttributeEditable(ManagedBeanPropertyForm.VALUE_KIND);
                this.combo.setEnabled(e);
                this.vklabel.setEnabled(e);
            }
        }
    }

    class ValueControl {
        protected Composite parent;
        protected Control control;
        private XAttributeSupport support;
        private static final String ATTRIBUTE_NAME = "value";
        private Control label;
        protected BF sb;

        public Control getControl() {
            return this.control;
        }

        public void activate() {
            if (this.control == null) {
                this.control = this.createControl(this.parent);
            }
        }

        public void deactivate() {
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setVisible(Boolean.FALSE.booleanValue());
                this.control.dispose();
                this.control = null;
            }
        }

        public void dispose() {
            if (this.control != null && !this.control.isDisposed()) {
                this.deactivate();
            }
            this.parent = null;
            if (this.sb != null) {
                this.sb.dispose();
            }
            this.sb = null;
        }

        public void setParent(Composite parent) {
            this.parent = parent;
        }

        public Control createControl(Composite parent) {
            if (this.control == null) {
                Composite composite = new Composite(parent, 0);
                composite.setBackground(parent.getBackground());
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 5;
                layout.verticalSpacing = 5;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                composite.setLayout((Layout)layout);
                List editors = this.support.getEditorList();
                for (PropertyEditor propertyEditor : editors) {
                    if (!"value".equals(propertyEditor.getAttributeName())) continue;
                    this.sb = new BF();
                    this.support.fillComposite(composite, propertyEditor, (StringButtonFieldEditorEx)this.sb);
                    this.sb.setChangeButtonText("View/Edit");
                    this.label = this.sb.getLabelComposite();
                }
                this.control = composite;
                this.support.updateEnablementByModelObject();
            }
            return this.control;
        }

        public void init(Object model) {
            this.support = new XAttributeSupport(ManagedBeanPropertyForm.this.settings);
            XModelObject object = (XModelObject)model;
            String entity = object.getModelEntity().getName();
            XEntityDataImpl ed = XEntityDataImpl.create((String[][])new String[][]{{entity}, {"value"}});
            this.support.init(object, (XEntityData)ed, true);
        }

        public void update() {
            if (this.control == null || this.control.isDisposed()) {
                return;
            }
            this.support.load();
            this.support.updateEnablementByModelObject();
        }

        public void setLabelLayoutData(Object layoutData) {
            if (this.label != null) {
                this.label.setLayoutData(layoutData);
                this.label.getParent().layout(true);
            }
        }

        class BF
        extends StringButtonFieldEditorEx {
            public BF() {
                super(ValueControl.this.support.getSettings());
            }

            protected String changePressed() {
                String vk = ManagedBeanPropertyForm.this.xmo.getAttributeValue(ManagedBeanPropertyForm.VALUE_KIND);
                if (ManagedBeanPropertyForm.NULL_VALUE_NAME.equals(vk)) {
                    return null;
                }
                if (ManagedBeanPropertyForm.MAP_ENTRIES_NAME.equals(vk) || ManagedBeanPropertyForm.LIST_ENTRIES_NAME.equals(vk)) {
                    XModelObject c = ManagedBeanPropertyForm.this.xmo.getChildByPath("Entries");
                    FindObjectHelper.findModelObject((XModelObject)c, (int)FindObjectHelper.IN_EDITOR_ONLY);
                    return null;
                }
                return super.changePressed();
            }

            public void setEnabled(boolean enabled) {
                if (ManagedBeanPropertyForm.this.xmo == null || !ManagedBeanPropertyForm.this.xmo.isObjectEditable()) {
                    super.setEnabled(enabled);
                } else {
                    String vk = ManagedBeanPropertyForm.this.xmo.getAttributeValue(ManagedBeanPropertyForm.VALUE_KIND);
                    if (this.getTextControl() != null) {
                        this.getTextControl().setEnabled(enabled);
                    }
                    if (this.getChangeControl() != null) {
                        this.getChangeControl().setEnabled(!ManagedBeanPropertyForm.NULL_VALUE_NAME.equals(vk));
                    }
                    if (this.getLabelControl() != null) {
                        this.getLabelControl().setEnabled(!ManagedBeanPropertyForm.NULL_VALUE_NAME.equals(vk));
                    }
                }
            }
        }
    }
}

