/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.ILinkListener;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.model.ISegment;
import org.jboss.tools.jsf.ui.editor.model.impl.Group;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFModel;
import org.jboss.tools.jsf.ui.editor.model.impl.Page;
import org.jboss.tools.jsf.ui.editor.model.impl.Segment;

public class Link
extends JSFElement
implements ILink {
    public static final String PATH_PROPERTY = "link shape";
    public static final String SHAPE_PROPERTY = "shape";
    public static final String HIDDEN_PROPERTY = "hidden";
    private String pathString;
    private String linkStatus;
    private boolean preferredMode = false;
    private int preferredLength = 0;
    List<ILinkListener> linkListeners = new Vector<ILinkListener>();
    XModelObject target = null;
    IGroup toGroup;
    ISegment headSegment;
    ISegment tailSegment;

    public void dispose() {
        super.dispose();
        if (this.linkListeners != null) {
            this.linkListeners.clear();
        }
        this.linkListeners = null;
    }

    public boolean isPreferredMode() {
        return this.preferredMode;
    }

    public int getPreferredLength() {
        if (this.preferredMode) {
            return this.preferredLength;
        }
        return 0;
    }

    public String getPathFromModel() {
        if (this.preferredMode) {
            return "";
        }
        return this.source.getAttributeValue(SHAPE_PROPERTY);
    }

    public PointList getPointList() {
        int[] path = null;
        this.pathString = this.source.getAttributeValue(SHAPE_PROPERTY);
        path = this.jsfModel.getHelper().asIntArray(this.source, SHAPE_PROPERTY);
        PointList list = new PointList();
        if (path.length < 4) {
            return list;
        }
        int i = 0;
        while (i < path.length) {
            list.addPoint(path[i], path[i + 1]);
            i += 2;
        }
        return list;
    }

    public void savePointList(PointList list) {
        String value = "";
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                value = String.valueOf(value) + ",";
            }
            Point p = list.getPoint(i);
            value = String.valueOf(value) + p.x + "," + p.y;
            ++i;
        }
        this.jsfModel.getHelper().setAttributeValue(this.source, SHAPE_PROPERTY, value);
    }

    public void clearPointList() {
        this.source.setAttributeValue(SHAPE_PROPERTY, "");
    }

    public Link(IJSFElement parent, XModelObject source) {
        super(parent, source);
        this.target = this.getJSFModel().getHelper().getItemOutputTarget(source);
        int[] path = null;
        this.pathString = source.getAttributeValue(SHAPE_PROPERTY);
        path = this.jsfModel.getHelper().asIntArray(source, SHAPE_PROPERTY);
        this.linkStatus = this.getLinkStatus();
        if (path.length > 1 && path[0] == -1) {
            this.preferredMode = true;
            this.preferredLength = path[1];
            path = new int[]{};
        } else {
            this.preferredMode = false;
        }
        Segment prevSegment = null;
        int i = 0;
        while (i < path.length) {
            Segment newSegment = new Segment((ILink)this, path[i], prevSegment);
            if (i == 0) {
                this.headSegment = newSegment;
            }
            if (i == path.length - 1) {
                this.tailSegment = newSegment;
            }
            prevSegment = newSegment;
            ++i;
        }
    }

    public void setTarget() {
        if (this.target == null) {
            return;
        }
        if (this.target.getPath() == null) {
            return;
        }
        this.toGroup = (IGroup)this.jsfModel.findElement(this.target.getPath());
        if (this.toGroup == null) {
            return;
        }
        if (this.toGroup != null) {
            ((Group)this.toGroup).addInputLink(this);
            ((Page)this.getParentJSFElement()).fireLinkAdd(this);
        }
    }

    public XModelObject getTargetModel() {
        return this.target;
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        return null;
    }

    public String getLinkName() {
        return this.getJSFModel().getHelper().getItemOutputPresentation(this.source);
    }

    public IGroup getToGroup() {
        return this.toGroup;
    }

    public IPage getFromPage() {
        return (IPage)this.getParentJSFElement();
    }

    public IGroup getFromGroup() {
        return this.getFromPage().getGroup();
    }

    public boolean isShortcut() {
        return this.jsfModel.getHelper().isShortcut(this.source);
    }

    public boolean isConfirmed() {
        if (((Group)this.getFromGroup()).type.equals("page")) {
            String subtype = this.source.getAttributeValue("subtype");
            return "confirmed".equals(subtype);
        }
        return true;
    }

    public boolean isHidden() {
        String hidden = this.source.getAttributeValue(HIDDEN_PROPERTY);
        return "yes".equals(hidden);
    }

    public void remove() {
    }

    public void addLinkListener(ILinkListener l) {
        this.linkListeners.add(l);
    }

    public void removeLinkListener(ILinkListener l) {
        this.linkListeners.remove(l);
    }

    public ISegment getHeadSegment() {
        return this.headSegment;
    }

    public ISegment getTailSegment() {
        return this.tailSegment;
    }

    public void setHeadSegment(ISegment segment) {
        ISegment oldHeadSegment = this.headSegment;
        this.headSegment = segment;
        this.propertyChangeSupport.firePropertyChange("headSegment", oldHeadSegment, segment);
    }

    public void setTailSegment(ISegment segment) {
        ISegment oldTailSegment = this.tailSegment;
        this.tailSegment = segment;
        this.propertyChangeSupport.firePropertyChange("tailSegment", oldTailSegment, segment);
    }

    public ISegment createSegment(int length, ISegment prevSegment) {
        Segment newSegment = new Segment((ILink)this, length, prevSegment);
        return newSegment;
    }

    public void fireLinkChange() {
        ArrayList<ILinkListener> targets = new ArrayList<ILinkListener>();
        targets.addAll(this.linkListeners);
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkChange(this);
            }
            ++i;
        }
    }

    public void fireLinkRemove() {
        ArrayList<ILinkListener> targets = new ArrayList<ILinkListener>();
        targets.addAll(this.linkListeners);
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkRemove(this);
            }
            ++i;
        }
        ((JSFModel)this.getJSFModel()).fireLinkRemove(this);
    }

    private String getLinkStatus() {
        return String.valueOf(this.source.getAttributeValue(HIDDEN_PROPERTY)) + ":" + this.source.getAttributeValue("shortcut");
    }

    public void nodeChanged(Object eventData) {
        int[] path = null;
        if (this.target == null) {
            this.target = this.getJSFModel().getHelper().getItemOutputTarget(this.source);
            if (this.target != null) {
                this.setTarget();
            }
        } else if (!this.target.equals(this.getJSFModel().getHelper().getItemOutputTarget(this.source))) {
            ((Group)this.toGroup).removeInputLink(this);
            this.target = this.getJSFModel().getHelper().getItemOutputTarget(this.source);
            this.setTarget();
            this.fireLinkChange();
            return;
        }
        String ls = this.getLinkStatus();
        String temp = this.source.getAttributeValue(SHAPE_PROPERTY);
        path = this.jsfModel.getHelper().asIntArray(this.source, SHAPE_PROPERTY);
        if (this.pathString.equals(temp) && (this.linkStatus == null || this.linkStatus.equals(ls))) {
            this.fireLinkChange();
            return;
        }
        if (path.length > 1 && path[0] == -1) {
            this.preferredMode = true;
            this.preferredLength = path[1];
            path = new int[]{};
        } else {
            this.preferredMode = false;
        }
        Segment prevSegment = null;
        int i = 0;
        while (i < path.length) {
            Segment newSegment = new Segment((ILink)this, path[i], prevSegment);
            if (i == 0) {
                this.headSegment = newSegment;
            }
            if (i == path.length - 1) {
                this.tailSegment = newSegment;
            }
            prevSegment = newSegment;
            ++i;
        }
        this.pathString = temp;
        this.linkStatus = ls;
        this.fireLinkChange();
    }
}

