/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.print;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.jsf.ui.editor.figures.DiagramFigure;
import org.jboss.tools.jsf.ui.editor.print.Page;
import org.jboss.tools.jsf.ui.editor.print.PageFormat;

public class Pages {
    public Image printImage = null;
    GraphicalViewer viewer = null;
    double scale = 1.0;
    int width = 0;
    int height = 0;
    PageFormat pageFormat = null;
    List<Page> mPages;
    List<Page> sPages = null;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    PropertyChangeListener pcl;
    int countX = 1;
    int countY = 1;
    boolean isText = false;
    String[] text;
    List<IFigure> figures = new Vector<IFigure>();
    public int ix = 0;
    public int iy = 0;

    public Pages(GraphicalViewer c, PageFormat pageFormat) {
        this(c, PageFormat.printScale, pageFormat, true);
    }

    public int computeStringWidth(Font f, String str) {
        return 0;
    }

    public void setPrintImage(Image printImage) {
        this.printImage = printImage;
    }

    public Image getPrintImage() {
        return this.printImage;
    }

    public int calculateMaxWidth(String str, Font f, int width) {
        int w = this.computeStringWidth(f, str);
        while (w > width) {
            str = str.substring(0, str.length() - 1);
            w = this.computeStringWidth(f, str);
        }
        return str.length();
    }

    public int calculateMaxStringCount(int height, Font f, int spacing) {
        int hs = spacing + f.getFontData()[0].getHeight();
        int count = (int)Math.floor(height / hs);
        if (count > 1) {
            --count;
        }
        return count;
    }

    public void getChilds(IFigure f) {
        for (IFigure o : f.getChildren()) {
            if (!(o instanceof DiagramFigure) && !(o instanceof Layer)) {
                this.figures.add(o);
            }
            this.getChilds(o);
        }
    }

    public Dimension getTrueSize() {
        List<IFigure> v = this.figures;
        Dimension d = new Dimension(0, 0);
        int i = 0;
        while (i < v.size()) {
            IFigure c = v.get(i);
            if (c.getBounds().x + c.getBounds().width > d.width) {
                d.setSize(c.getBounds().x + c.getBounds().width, d.height);
            }
            if (c.getBounds().y + c.getBounds().height > d.height) {
                d.setSize(d.width, c.getBounds().y + c.getBounds().height);
            }
            if (c.getBounds().x < this.ix) {
                this.ix = c.getBounds().x;
            }
            if (c.getBounds().y < this.iy) {
                this.iy = c.getBounds().y;
            }
            ++i;
        }
        d.width += Math.abs(this.ix);
        d.height += Math.abs(this.iy);
        return d;
    }

    public Pages(GraphicalViewer viewer, double scale, PageFormat pageFormat, boolean trueSize) {
        this.viewer = viewer;
        this.scale = scale;
        this.pageFormat = pageFormat;
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        this.getChilds(f);
        this.width = this.getTrueSize().width;
        this.height = this.getTrueSize().height;
        this.pcl = this.createSelectionListener();
        this.createPages();
    }

    public boolean isTextPrint() {
        return this.isText;
    }

    public PropertyChangeListener createSelectionListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("select")) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        if (!Pages.this.mPages.contains(evt.getSource())) {
                            Pages.this.mPages.add((Page)evt.getSource());
                        }
                        Pages.this.pcs.firePropertyChange("PageSelection", false, true);
                        if (Pages.this.mPages.size() == Pages.this.sPages.size()) {
                            Pages.this.pcs.firePropertyChange("selectAll", false, true);
                        }
                    } else {
                        Pages.this.mPages.remove((Page)evt.getSource());
                        Pages.this.pcs.firePropertyChange("PageSelection", false, true);
                        if (Pages.this.mPages.size() == 0) {
                            Pages.this.pcs.firePropertyChange("unSelectAll", false, true);
                        }
                    }
                }
            }
        };
    }

    void createPages() {
        ArrayList<Page> oldPages = null;
        if (this.sPages != null) {
            oldPages = new ArrayList<Page>();
            oldPages.addAll(this.sPages);
        }
        this.mPages = new Vector<Page>();
        this.sPages = new Vector<Page>();
        int pWidth = this.getPageFormat().getImageableWidth();
        int pHeight = this.getPageFormat().getImageableHeight();
        int sWidth = (int)(this.getScale() * (double)this.width);
        int sHeight = (int)(this.getScale() * (double)this.height);
        int oldCountX = this.countX;
        int oldCountY = this.countY;
        this.countX = 1;
        this.countY = 1;
        if (sWidth > pWidth) {
            this.countX = (int)Math.round((double)(sWidth / pWidth) + 0.5);
        }
        if (sHeight > pHeight) {
            this.countY = (int)Math.round((double)(sHeight / pHeight) + 0.5);
        }
        int i = 0;
        while (i < this.countY) {
            int j = 0;
            while (j < this.countX) {
                Page newPage = new Page(this, new Rectangle((int)((double)(this.getPageFormat().getImageableWidth() * j) / this.getScale()), (int)((double)(this.getPageFormat().getImageableHeight() * i) / this.getScale()), (int)((double)this.getPageFormat().getImageableWidth() / this.getScale()), (int)((double)this.getPageFormat().getImageableHeight() / this.getScale())), this.viewer, this.getPageFormat(), this.getScale(), this.getPageFormat().getImageableWidth() * j, this.getPageFormat().getImageableHeight() * i, this.getSourcePagesCount() + 1);
                newPage.addPropertyChangeListener(this.pcl);
                this.sPages.add(newPage);
                ++j;
            }
            ++i;
        }
        if (oldCountX != this.countX || oldCountY != this.countY) {
            this.selectAll();
        } else if (oldPages != null) {
            i = 0;
            while (i < oldPages.size()) {
                this.sPages.get(i).setSelected(((Page)oldPages.get(i)).isSelected());
                ++i;
            }
        } else {
            this.selectAll();
        }
    }

    public Page getSourcePage(int index) {
        return this.sPages.get(index);
    }

    public int getSourcePagesCount() {
        return this.sPages.size();
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        if (!this.isTextPrint()) {
            this.createPages();
        }
        this.pcs.firePropertyChange("scale", new Double(oldScale), new Double(scale));
    }

    public void selectAll() {
        int i = 0;
        while (i < this.sPages.size()) {
            this.sPages.get(i).setSelected(true);
            ++i;
        }
        this.pcs.firePropertyChange("selectAll", false, true);
    }

    public void unSelectAll() {
        int i = 0;
        while (i < this.sPages.size()) {
            this.sPages.get(i).setSelected(false);
            ++i;
        }
        this.pcs.firePropertyChange("unSelectAll", false, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public int getNumberOfPages() {
        return this.mPages.size();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.mPages.get(pageIndex).getPageFormat();
    }

    public Page getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this.mPages.get(pageIndex);
    }

    public Dimension getDimension() {
        return new Dimension((int)((double)(this.countX * this.pageFormat.getImageableWidth()) / this.getScale()), (int)((double)(this.countY * this.pageFormat.getImageableHeight()) / this.getScale()));
    }
}

