/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.print;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.ui.editor.JSFEditor;
import org.jboss.tools.jsf.ui.editor.print.PageFormat;
import org.jboss.tools.jsf.ui.editor.print.Pages;
import org.jboss.tools.jsf.ui.editor.print.PagesView;

public class PrintPreviewDialog
extends Dialog {
    String message = "";
    String result = null;
    Shell dialog;
    Text text;
    Display display;
    GraphicalViewer viewer;
    JSFEditor editor;
    Rectangle dialogSize = new Rectangle(0, 0, 640, 480);
    PagesView imageView;
    Pages pages;

    public PrintPreviewDialog(Shell parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
    }

    public PrintPreviewDialog(Shell parent) {
        this(parent, 65536);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String open() {
        this.dialog = new Shell(this.getParent(), this.getStyle());
        this.dialog.setText(JSFUIMessages.PRINT_PREVIEW);
        GridLayout rl = new GridLayout();
        this.dialog.setLayout((Layout)rl);
        ControlPanel controlPanel = new ControlPanel((Composite)this.dialog, 16);
        GridData rd = new GridData();
        rd.widthHint = 550;
        rd.heightHint = 105;
        controlPanel.setLayoutData(rd);
        this.imageView = new PagesView(this.pages, new Dimension(550, 370), (Composite)this.dialog, 16);
        this.imageView.setBackground(new Color((Device)this.dialog.getDisplay(), 255, 255, 255));
        GridData rd1 = new GridData();
        rd1.widthHint = 550;
        rd1.heightHint = 400;
        this.imageView.setLayoutData(rd1);
        Composite buttons = new Composite((Composite)this.dialog, 0x1000018);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        buttons.setLayout((Layout)grid);
        GridData data2 = new GridData(128);
        buttons.setLayoutData((Object)data2);
        GridData data = new GridData(128);
        Button ok = new Button(buttons, 0);
        ok.setText(JSFUIMessages.PRINT);
        data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintPreviewDialog.this.result = "ok";
                if (PrintPreviewDialog.this.editor.isBordersPaint()) {
                    PrintPreviewDialog.this.pages.unSelectAll();
                    PrintPreviewDialog.this.pages.getSourcePage(0).setSelected(true);
                }
                PrintPreviewDialog.this.dialog.dispose();
            }
        });
        Button cancel = new Button(buttons, 8);
        cancel.setText(JSFUIMessages.CLOSE);
        data = new GridData(128);
        data.widthHint = 75;
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintPreviewDialog.this.result = "cancel";
                PrintPreviewDialog.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(ok);
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    public void setPrintViewer(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public void setEditor(JSFEditor editor) {
        this.editor = editor;
    }

    public GraphicalViewer getPrintViewer() {
        return this.viewer;
    }

    public void setPages(Pages pages) {
        this.pages = pages;
    }

    public Pages getPages() {
        return this.pages;
    }

    public class ControlPanel
    extends Composite
    implements PaintListener {
        Button all;
        SliderPanel sp;
        Button selectPage;
        Button selectAll;
        Button unselectAll;
        SelectionListener allListener;
        SelectionListener selectListener;
        SelectionListener selectAllListener;
        SelectionListener unSelectAllListener;

        public ControlPanel(Composite parent, int style) {
            super(parent, style);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.verticalSpacing = -12;
            this.setLayout((Layout)gl);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 1;
            data.horizontalIndent = 8;
            Label print = new Label((Composite)this, 0);
            print.setText(JSFUIMessages.PRINT);
            print.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 1;
            data.horizontalIndent = 8;
            Label zoom = new Label((Composite)this, 0);
            zoom.setText(JSFUIMessages.ZOOM);
            zoom.setLayoutData((Object)data);
            Group gr1 = new Group((Composite)this, 16);
            gl = new GridLayout();
            gl.numColumns = 2;
            gr1.setLayout((Layout)gl);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            gr1.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            data.horizontalAlignment = 4;
            this.all = new Button((Composite)gr1, 16);
            this.all.setText(JSFUIMessages.ZOOM);
            this.all.setSelection(true);
            this.all.setLayoutData((Object)data);
            this.selectPage = new Button((Composite)gr1, 16);
            this.selectPage.setText(JSFUIMessages.SELECTED_PAGES);
            data = new GridData();
            data.horizontalSpan = 2;
            data.horizontalAlignment = 4;
            this.selectPage.setLayoutData((Object)data);
            this.selectAll = new Button((Composite)gr1, 8);
            this.selectAll.setText(JSFUIMessages.SELECT_ALL);
            this.selectAll.setEnabled(false);
            this.unselectAll = new Button((Composite)gr1, 8);
            this.unselectAll.setText(JSFUIMessages.UNSELECT_ALL);
            this.unselectAll.setEnabled(false);
            Group gr2 = new Group((Composite)this, 16);
            gl = new GridLayout();
            gl.numColumns = 1;
            gl.marginHeight = 3;
            gl.verticalSpacing = 2;
            gr2.setLayout((Layout)gl);
            data = new GridData();
            data.horizontalAlignment = 3;
            gr2.setLayoutData((Object)data);
            this.sp = new SliderPanel((Composite)gr2, 0);
            data = new GridData();
            data.horizontalAlignment = 3;
            this.sp.setLayoutData(data);
            this.allListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.pages.selectAll();
                    ControlPanel.this.selectAll.setEnabled(false);
                    ControlPanel.this.unselectAll.setEnabled(false);
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.imageView.setSelectionEnabled(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.all.addSelectionListener(this.allListener);
            this.selectListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.imageView.setSelectionEnabled(true);
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.pages.unSelectAll();
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.imageView.redraw();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.selectPage.addSelectionListener(this.selectListener);
            PropertyChangeListener pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("selectAll") && !ControlPanel.this.all.getSelection()) {
                        ControlPanel.this.selectAll.setEnabled(false);
                        ControlPanel.this.unselectAll.setEnabled(true);
                        ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.imageView.redraw();
                    }
                    if (e.getPropertyName().equals("unSelectAll") && !ControlPanel.this.all.getSelection()) {
                        ControlPanel.this.unselectAll.setEnabled(false);
                        ControlPanel.this.selectAll.setEnabled(true);
                        ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.imageView.redraw();
                    }
                    if (e.getPropertyName().equals("PageSelection") && !ControlPanel.this.all.getSelection()) {
                        ControlPanel.this.unselectAll.setEnabled(true);
                        ControlPanel.this.selectAll.setEnabled(true);
                    }
                }
            };
            PrintPreviewDialog.this.pages.addPropertyChangeListener(pcl);
            this.selectAllListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.pages.selectAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.selectAll.addSelectionListener(this.selectAllListener);
            this.unSelectAllListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((ControlPanel)ControlPanel.this).PrintPreviewDialog.this.pages.unSelectAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.unselectAll.addSelectionListener(this.unSelectAllListener);
        }

        public void paintControl(PaintEvent pevent) {
            GC gc = pevent.gc;
            gc.setForeground(new Color((Device)this.getDisplay(), 0, 0, 0));
            gc.drawLine(pevent.x, pevent.y, pevent.width, pevent.x);
            gc.drawLine(pevent.x, pevent.y, pevent.x, pevent.height);
            gc.drawLine(pevent.x, pevent.y + pevent.height - 2, pevent.x + pevent.width, pevent.y + pevent.height - 2);
            gc.drawLine(pevent.x + pevent.width - 2, pevent.y + pevent.height, pevent.x + pevent.width - 2, pevent.y);
            gc.setForeground(new Color((Device)this.getDisplay(), 255, 255, 255));
            gc.drawLine(pevent.x + 1, pevent.y + 1, pevent.width - 1, pevent.x + 1);
            gc.drawLine(pevent.x + 1, pevent.y + 1, pevent.x + 1, pevent.height - 1);
            gc.dispose();
        }
    }

    public class SliderPanel
    extends Composite {
        Scale sc;
        Label percent;

        public SliderPanel(Composite parent, int style) {
            super(parent, style);
            GridLayout gl = new GridLayout();
            gl.numColumns = 1;
            this.setLayout((Layout)gl);
            this.percent = new Label((Composite)this, 0x1000000);
            this.percent.setText(String.valueOf(String.valueOf((int)(PageFormat.printScale * 100.0))) + JSFUIMessages.OF_NORMAL_SIZE);
            GridData gd = new GridData();
            gd.horizontalAlignment = 2;
            this.percent.setLayoutData((Object)gd);
            gd = new GridData();
            gd.horizontalAlignment = 2;
            this.sc = new Scale((Composite)this, 256);
            this.sc.setMinimum(30);
            this.sc.setMaximum(300);
            this.sc.setIncrement(10);
            this.sc.setSelection((int)(PrintPreviewDialog.this.pages.getScale() * 100.0));
            this.sc.setLayoutData((Object)gd);
            this.sc.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SliderPanel.this.percent.setText(String.valueOf(String.valueOf(SliderPanel.this.sc.getSelection())) + JSFUIMessages.OF_NORMAL_SIZE);
                    SliderPanel.this.percent.redraw();
                    ((SliderPanel)SliderPanel.this).PrintPreviewDialog.this.pages.setScale((double)SliderPanel.this.sc.getSelection() / 100.0);
                    PageFormat.printScale = (double)SliderPanel.this.sc.getSelection() / 100.0;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

