/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.el.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.jsf.el.refactoring.ELProjectSetExtension;
import org.jboss.tools.jsf.el.refactoring.ProjectsSet;
import org.jboss.tools.jsf.el.refactoring.RefactorSearcher;

public class ELReferencesQueryParticipant
implements IQueryParticipant {
    private ELSearcher searcher;

    public int estimateTicks(QuerySpecification specification) {
        return 10;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            if (!this.isSearchForReferences(querySpecification.getLimitTo())) {
                return;
            }
            ElementQuerySpecification qs = (ElementQuerySpecification)querySpecification;
            if (qs.getElement() instanceof IMethod || qs.getElement() instanceof IType) {
                IFile file = (IFile)qs.getElement().getResource();
                String name = qs.getElement().getElementName();
                this.searcher = new ELSearcher(requestor, qs.getElement(), file, name);
                this.searcher.setSearchScope(qs.getScope());
                this.searcher.findELReferences();
            }
        }
    }

    public boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }

    class ELSearcher
    extends RefactorSearcher {
        ISearchRequestor requestor;
        ProjectsSet projectSet;

        public ELSearcher(ISearchRequestor requestor, IJavaElement element, IFile file, String name) {
            super(file, name, element);
            this.projectSet = null;
            this.requestor = requestor;
            ELProjectSetExtension[] extensions = ELProjectSetExtension.getInstances();
            if (extensions.length > 0) {
                this.projectSet = extensions[0].getProjectSet();
                if (this.projectSet != null) {
                    this.projectSet.init(file.getProject());
                }
            }
        }

        protected boolean isFileCorrect(IFile file) {
            if (!file.isSynchronized(0)) {
                return false;
            }
            if (file.isPhantom()) {
                return false;
            }
            return !file.isReadOnly();
        }

        protected void match(IFile file, int offset, int length) {
            Match match = new Match((Object)file, offset, length);
            this.requestor.reportMatch(match);
        }

        protected IProject[] getProjects() {
            if (this.projectSet != null) {
                return this.projectSet.getLinkedProjects();
            }
            return new IProject[]{this.baseFile.getProject()};
        }

        protected IContainer getViewFolder(IProject project) {
            if (this.projectSet != null) {
                return this.projectSet.getViewFolder(project);
            }
            IPath path = ProjectHome.getFirstWebContentPath((IProject)this.baseFile.getProject());
            if (path != null) {
                return project.getFolder(path.removeFirstSegments(1));
            }
            return null;
        }
    }
}

