/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.project.capabilities.JSFCapabilities;

public class JSFCapabilitiesPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.jboss.tools.jsf.ui.capabilities";
    static String[] CAPABILITIES_HEADER = new String[]{"name"};
    static String[] FILE_ADDITIONS_HEADER = new String[]{"label"};
    static String[] LIB_REFERENCE_HEADER = new String[]{"name"};
    JSFCapabilities capabilities;
    XModelObject copy;
    XChildrenEditor capabilityList;
    XChildrenEditor fileAdditionList;
    XChildrenEditor librarySetList;

    public JSFCapabilitiesPreferencesPage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.capabilities = JSFCapabilities.getInstance();
        this.copy = this.capabilities.copy();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createCapabilityList();
        Control c = this.capabilityList.createControl(composite);
        c.setLayoutData((Object)new GridData(1808));
        this.createLibrarySetList();
        this.createFileAdditionList();
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(JSFUIMessages.LIBRARY_SETS);
        c = this.librarySetList.createControl((Composite)folder);
        c.setLayoutData((Object)new GridData(1808));
        item.setControl(c);
        item = new TabItem(folder, 0);
        item.setText(JSFUIMessages.CONFIGURATION_FILE_ADDITIONS);
        c = this.fileAdditionList.createControl((Composite)folder);
        c.setLayoutData((Object)new GridData(1808));
        item.setControl(c);
        this.initSelection();
        return composite;
    }

    private void initSelection() {
        if (this.copy == null || this.copy.getChildren().length == 0) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                JSFCapabilitiesPreferencesPage.this.capabilityList.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)JSFCapabilitiesPreferencesPage.this.copy.getChildren()[0]));
                JSFCapabilitiesPreferencesPage.this.capabilityList.update();
                JSFCapabilitiesPreferencesPage.this.capabilitySelectionChanged();
            }
        });
    }

    private void createCapabilityList() {
        this.capabilityList = new XChildrenEditor(){

            protected String getAddActionPath() {
                return "CreateActions.AddCapability";
            }

            protected AbstractTableHelper createHelper() {
                return new AbstractTableHelper(){

                    public String[] getHeader() {
                        return CAPABILITIES_HEADER;
                    }
                };
            }
        };
        this.capabilityList.setObject(this.copy);
        this.capabilityList.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSFCapabilitiesPreferencesPage.this.capabilitySelectionChanged();
            }
        });
        this.capabilityList.setHeaderVisible(false);
    }

    private void createLibrarySetList() {
        this.librarySetList = new XChildrenEditor(){

            protected String getAddActionPath() {
                return "CreateActions.AddLibraryReference";
            }

            protected void edit() {
                XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
                if (o != null) {
                    this.callAction(o, "EditActions.Edit");
                }
            }

            protected AbstractTableHelper createHelper() {
                return new AbstractTableHelper(){

                    public int size() {
                        return this.object == null ? 0 : this.object.getChildren("JSFLibraryReference").length;
                    }

                    public XModelObject getModelObject(int r) {
                        if (this.object == null) {
                            return null;
                        }
                        XModelObject[] cs = this.object.getChildren("JSFLibraryReference");
                        return r < 0 || r >= cs.length ? null : cs[r];
                    }

                    public String[] getHeader() {
                        return LIB_REFERENCE_HEADER;
                    }
                };
            }
        };
        this.librarySetList.setHeaderVisible(false);
    }

    private void createFileAdditionList() {
        this.fileAdditionList = new XChildrenEditor(){

            protected String getAddActionPath() {
                return "CreateActions.AddFileAddition";
            }

            protected void edit() {
                XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
                if (o != null) {
                    this.callAction(o, "EditActions.Edit");
                }
            }

            protected AbstractTableHelper createHelper() {
                return new AbstractTableHelper(){

                    public int size() {
                        return this.object == null ? 0 : this.object.getChildren("JSFFileAddition").length;
                    }

                    public XModelObject getModelObject(int r) {
                        if (this.object == null) {
                            return null;
                        }
                        XModelObject[] cs = this.object.getChildren("JSFFileAddition");
                        return r < 0 || r >= cs.length ? null : cs[r];
                    }

                    public String[] getHeader() {
                        return FILE_ADDITIONS_HEADER;
                    }
                };
            }
        };
        this.fileAdditionList.setHeaderVisible(false);
    }

    private void capabilitySelectionChanged() {
        XModelObject selection = this.capabilityList.getSelectedObject();
        this.librarySetList.setObject(selection);
        this.librarySetList.update();
        this.fileAdditionList.setObject(selection);
        this.fileAdditionList.update();
    }

    public boolean performCancel() {
        this.copy = this.capabilities.copy();
        return super.performCancel();
    }

    public boolean performOk() {
        long ts = this.capabilities.getTimeStamp();
        try {
            EnginesLoader.merge((XModelObject)this.capabilities, (XModelObject)this.copy);
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (ts != this.capabilities.getTimeStamp()) {
            this.capabilities.setModified(ts != this.capabilities.getTimeStamp());
            this.capabilities.save();
        }
        return super.performOk();
    }
}

