/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.wizard.bean;

import java.beans.PropertyChangeEvent;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.CheckBoxFieldEditor;
import org.jboss.tools.common.model.ui.wizards.special.SpecialWizardStep;
import org.jboss.tools.jsf.model.handlers.bean.AddManagedPropertySupport;

public class AddManagedBeanPropertyScreen
extends SpecialWizardStep {
    static int INDENT = 18;
    boolean lock = false;

    public Control createControl(Composite parent) {
        this.stepControl = this.attributes.createControl(parent);
        this.shiftFields();
        this.updateFieldEnablement();
        return this.stepControl;
    }

    private void shiftFields() {
        FieldEditor f = this.attributes.getFieldEditorByName("generate getter");
        if (f == null) {
            return;
        }
        CheckBoxFieldEditor cb = (CheckBoxFieldEditor)f;
        cb.setIndent(INDENT);
        f = this.attributes.getFieldEditorByName("generate setter");
        cb = (CheckBoxFieldEditor)f;
        cb.setIndent(INDENT);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.lock) {
            return;
        }
        if (event.getSource() == this.attributes.getPropertyEditorAdapterByName("property-name")) {
            this.processNameChange((String)event.getNewValue());
        }
        super.propertyChange(event);
    }

    void processNameChange(String newValue) {
        this.lock = true;
        try {
            AddManagedPropertySupport ps = (AddManagedPropertySupport)this.support;
            String type = ps.getFieldType(newValue);
            type = this.revalidateType(type);
            IModelPropertyEditorAdapter vp = this.attributes.getPropertyEditorAdapterByName("property-class");
            if (type != null) {
                vp.setValue((Object)type);
            }
        }
        finally {
            this.lock = false;
        }
    }

    String revalidateType(String type) {
        if (type == null || type.length() == 0 || type.indexOf(".") >= 0) {
            return type;
        }
        if (type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("char")) {
            return "java.lang.Character";
        }
        if (type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("short")) {
            return "java.lang.Short";
        }
        return type;
    }
}

