/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import org.eclipse.core.runtime.Platform;
import org.jboss.tools.vpe.xulrunner.editor.IXulRunnerVpeResizer;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSEvent;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

public class VpeResizerMouseListener
implements nsIDOMEventListener {
    private IXulRunnerVpeResizer vpeResizer;

    public VpeResizerMouseListener(IXulRunnerVpeResizer vpeResizer) {
        this.vpeResizer = vpeResizer;
    }

    public void handleEvent(nsIDOMEvent event) {
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        if (mouseEvent == null) {
            return;
        }
        if ("mousedown".equals(mouseEvent.getType())) {
            this.mouseDown(mouseEvent);
            event.preventDefault();
            event.stopPropagation();
        } else if ("mouseup".equals(mouseEvent.getType())) {
            this.mouseUp(mouseEvent);
        }
    }

    public nsISupports queryInterface(String aIID) {
        if (aIID.equals("{df31c120-ded6-11d1-bd85-00805f8ae3f4}")) {
            return this;
        }
        return Mozilla.queryInterface((nsISupports)this, (String)aIID);
    }

    private void mouseDown(nsIDOMMouseEvent mouseEvent) {
        nsIDOMElement domElement;
        nsIDOMEventTarget eventTarget;
        nsIDOMNSEvent internalEvent;
        boolean isContextClick = false;
        if (Platform.getOS().equals("SunOS")) {
            isContextClick = mouseEvent.getCtrlKey();
        } else {
            boolean bl = isContextClick = mouseEvent.getButton() == 2;
        }
        if (!isContextClick && mouseEvent.getButton() == 0 && mouseEvent.getDetail() == 1 && (internalEvent = (nsIDOMNSEvent)mouseEvent.queryInterface("{e565d518-4510-407f-a3d9-3b4107549c6d}")) != null && (eventTarget = internalEvent.getExplicitOriginalTarget()) != null && (domElement = (nsIDOMElement)eventTarget.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")) != null) {
            int clientX = mouseEvent.getClientX();
            int clientY = mouseEvent.getClientY();
            this.vpeResizer.mouseDown(clientX, clientY, domElement);
        }
    }

    private void mouseUp(nsIDOMMouseEvent mouseEvent) {
        nsIDOMElement domElement;
        nsIDOMEventTarget target = mouseEvent.getTarget();
        if (target != null && (domElement = (nsIDOMElement)target.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}")) != null) {
            int clientX = mouseEvent.getClientX();
            int clientY = mouseEvent.getClientY();
            this.vpeResizer.mouseUp(clientX, clientY, domElement);
        }
    }
}

