/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.jboss.tools.vpe.xulrunner.BrowserPlugin;
import org.jboss.tools.vpe.xulrunner.XulRunnerException;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;
import org.jboss.tools.vpe.xulrunner.editor.IVpeResizeListener;
import org.jboss.tools.vpe.xulrunner.editor.IXulRunnerVpeResizer;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerVpeResizer;
import org.mozilla.interfaces.inIFlasher;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIClipboardDragDropHookList;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentRange;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISelectionListener;
import org.mozilla.interfaces.nsISelectionPrivate;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class XulRunnerEditor
extends XulRunnerBrowser {
    private VisualPaintListener paintListener;
    private IVpeResizeListener resizeListener;
    private IXulRunnerVpeResizer xulRunnerVpeResizer;
    public static final String flasherVisialElementColor = "#0000ff";
    public static final String flasherHiddentElementColor = "#ff0000";
    private nsIDOMElement lastBorderedElement;
    private static final String INVISIBLE_ELEMENT_BORDER = "border: 2px solid red !important;";
    private static final String VISIBLE_ELEMENT_BORDER = "border: 2px solid blue !important;";
    private static final String PREV_STYLE_ATTR_NAME = "oldstyle";
    public static String VPEFLASHERCOLORATTRIBUTE = "vpeFlasherColorAttribute";
    public static final String TRANS_FLAVOR_kHTMLMime = "text/html";
    public static final String TRANS_FLAVOR_kURLDataMime = "text/x-moz-url-data";
    public static final String TRANS_FLAVOR_kFileMime = "application/x-moz-file";
    public static final String TRANS_FLAVOR_kURLMime = "text/x-moz-url";
    public static final String TRANS_FLAVOR_kUnicodeMime = "text/unicode";
    public static final String TRANS_FLAVOR_kNativeHTMLMime = "application/x-moz-nativehtml";
    private inIFlasher iFlasher;
    private nsIDocShell docShell = null;
    private static final Pattern PATTERN = Pattern.compile(".*\\s*(display)\\s*:\\s*(none)\\s*;.*", 34);
    private static final String STYLE_ATTR = "style";
    private nsIDOMNode lastSelectedNode;
    private int lastResizerConstrains;
    private boolean scrollRegtangleFlag = false;
    private nsISelectionListener selectionListener;
    private Listener eventListenet = new Listener(){

        public void handleEvent(Event event) {
            Display.getCurrent().asyncExec((Runnable)new Thread(){

                public void run() {
                    if (XulRunnerEditor.this.getBrowser() != null && !XulRunnerEditor.this.getBrowser().isDisposed()) {
                        XulRunnerEditor.this.showResizer();
                        XulRunnerEditor.this.showSelectionRectangle();
                    }
                }
            });
        }
    };

    public XulRunnerEditor(Composite parent) throws XulRunnerException {
        super(parent);
        this.getBrowser().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (XulRunnerEditor.this.paintListener != null) {
                    XulRunnerEditor.this.getBrowser().getParent().removePaintListener((PaintListener)XulRunnerEditor.this.paintListener);
                    XulRunnerEditor.this.paintListener = null;
                }
                XulRunnerEditor.this.getWebBrowser().removeWebBrowserListener((nsISupports)XulRunnerEditor.this, "{44b78386-1dd2-11b2-9ad2-e4eee2ca1916}");
                XulRunnerEditor.this.removeProgressListener(XulRunnerEditor.this);
                XulRunnerEditor.this.removeSelectionListener();
                if (XulRunnerEditor.this.resizeListener != null) {
                    XulRunnerEditor.this.getIXulRunnerVpeResizer().removeResizeListener(XulRunnerEditor.this.resizeListener);
                }
                XulRunnerEditor.this.xulRunnerVpeResizer.dispose();
                XulRunnerEditor.this.xulRunnerVpeResizer = null;
                XulRunnerEditor.this.resizeListener = null;
                if (XulRunnerEditor.this.eventListenet != null) {
                    XulRunnerEditor.this.removeListener(9, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(22, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(15, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(13, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.removeListener(11, XulRunnerEditor.this.eventListenet);
                    XulRunnerEditor.this.eventListenet = null;
                }
                XulRunnerEditor.this.getBrowser().removeDisposeListener((DisposeListener)this);
                XulRunnerEditor.this.onDispose();
            }
        });
        this.paintListener = new VisualPaintListener();
        this.getBrowser().getParent().addPaintListener((PaintListener)this.paintListener);
        this.addListener(11, this.eventListenet);
        this.addListener(22, this.eventListenet);
        this.addListener(15, this.eventListenet);
        this.addListener(13, this.eventListenet);
        this.addListener(9, this.eventListenet);
        this.resizeListener = new IVpeResizeListener(){

            public void onEndResizing(int usedResizeMarkerHandle, int top, int left, int width, int height, nsIDOMElement resizedDomElement) {
                XulRunnerEditor.this.endResizing(usedResizeMarkerHandle, top, left, width, height, resizedDomElement);
            }

            public nsISupports queryInterface(String uuid) {
                return null;
            }
        };
    }

    public boolean isMozillaDragFlavor() {
        nsITransferable transferable;
        nsIDragSession dragSession = this.getCurrentDragSession();
        if (dragSession != null && (transferable = this.createTransferable()) != null) {
            transferable.addDataFlavor(TRANS_FLAVOR_kURLDataMime);
            transferable.addDataFlavor(TRANS_FLAVOR_kFileMime);
            transferable.addDataFlavor(TRANS_FLAVOR_kURLMime);
            transferable.addDataFlavor(TRANS_FLAVOR_kUnicodeMime);
            dragSession.getData(transferable, 0L);
            String[] flavors = new String[1];
            nsISupports[] data = new nsISupports[1];
            long[] length = new long[1];
            transferable.getAnyTransferData(flavors, data, length);
            return length[0] > 0L;
        }
        return false;
    }

    public void onElementResize(nsIDOMElement element, int handle, int top, int left, int width, int height) {
    }

    public void removeResizerListener() {
        if (this.resizeListener != null) {
            this.getIXulRunnerVpeResizer().removeResizeListener(this.resizeListener);
        }
    }

    public void addResizerListener() {
        if (this.getIXulRunnerVpeResizer() != null) {
            this.getIXulRunnerVpeResizer().init(this.getDOMDocument());
            this.getIXulRunnerVpeResizer().addResizeListener(this.resizeListener);
        }
    }

    public void onLoadWindow() {
        this.addResizerListener();
    }

    public nsIDragSession getCurrentDragSession() {
        nsIServiceManager serviceManager = this.getServiceManager();
        nsIDragService dragService = (nsIDragService)serviceManager.getServiceByContractID("@mozilla.org/widget/dragservice;1", "{82b58ada-f490-4c3d-b737-1057c4f1d052}");
        return dragService.getCurrentSession();
    }

    public nsIClipboardDragDropHookList getClipboardDragDropHookList() {
        nsIDocShell docShell = this.getDocShell();
        if (docShell != null) {
            nsIClipboardDragDropHookList hookList = (nsIClipboardDragDropHookList)docShell.queryInterface("{876a2015-6b66-11d7-8f18-0003938a9d96}");
            return hookList;
        }
        return null;
    }

    public nsIDocShell getDocShell() {
        if (this.docShell == null) {
            nsIInterfaceRequestor interfaceRequestor = (nsIInterfaceRequestor)this.getWebBrowser().queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
            this.docShell = (nsIDocShell)interfaceRequestor.getInterface("{dc4daea1-b43d-406f-bd62-c2ee879192ad}");
        }
        return this.docShell;
    }

    public nsIDOMDocument getDOMDocument() {
        nsIDOMWindow domWindow = this.getWebBrowser().getContentDOMWindow();
        return domWindow.getDocument();
    }

    public nsIDOMDocumentRange getDOMDocumentRange() {
        return (nsIDOMDocumentRange)this.getDOMDocument().queryInterface("{7b9badc6-c9bc-447a-8670-dbd195aed24b}");
    }

    public nsIDOMRange createDOMRange() {
        return this.getDOMDocumentRange().createRange();
    }

    public void showDragCaret(nsIDOMNode node, long offcet) {
        System.out.println("Show drag caret for " + node.getNodeName() + ":" + offcet);
    }

    public void hideDragCaret() {
        System.out.println("Hide drag caret");
    }

    public nsITransferable createTransferable() {
        nsIComponentManager componentManager = this.getComponentManager();
        return (nsITransferable)componentManager.createInstanceByContractID("@mozilla.org/widget/transferable;1", (nsISupports)this, "{8b5314bc-db01-11d2-96ce-0060b0fb9956}");
    }

    public nsISelection getSelection() {
        nsIDOMWindow domWindow = this.getWebBrowser().getContentDOMWindow();
        nsISelection selection = domWindow.getSelection();
        return selection;
    }

    public nsIDOMElement getLastSelectedElement() {
        return this.getElement(this.lastSelectedNode);
    }

    public nsIDOMNode getLastSelectedNode() {
        return this.lastSelectedNode;
    }

    private void setLastSelectedNode(nsIDOMNode lastSelectedNode) {
        this.lastSelectedNode = lastSelectedNode;
    }

    public void setSelectionRectangle(nsIDOMNode node, int resizerConstrains, boolean scroll) {
        if (this.getIFlasher() == null) {
            return;
        }
        nsIDOMElement element = this.getElement(node);
        if (element != null) {
            try {
                ((nsIBaseWindow)this.getWebBrowser().queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}")).repaint(true);
            }
            catch (XPCOMException ex) {
                BrowserPlugin.getDefault().logInfo("repaint failed", ex);
            }
            if (scroll) {
                this.scrollToElement(element);
                this.scrollRegtangleFlag = true;
            }
            if (this.checkVisability((nsIDOMNode)element)) {
                if (element.getAttribute(VPEFLASHERCOLORATTRIBUTE) == null || !element.getAttribute(VPEFLASHERCOLORATTRIBUTE).equals(flasherHiddentElementColor)) {
                    this.getIFlasher().setColor(flasherVisialElementColor);
                } else {
                    this.getIFlasher().setColor(flasherHiddentElementColor);
                }
                this.drawElementOutline(element);
            } else {
                this.getIFlasher().setColor(flasherHiddentElementColor);
                nsIDOMElement domElement = this.findVisbleParentElement(element);
                if (domElement != null) {
                    this.drawElementOutline(domElement);
                }
            }
        }
        if (this.xulRunnerVpeResizer != null) {
            if (element != null && resizerConstrains != 0) {
                this.xulRunnerVpeResizer.show(element, resizerConstrains);
            } else {
                this.xulRunnerVpeResizer.hide();
            }
        }
        this.setLastSelectedNode(node);
        this.lastResizerConstrains = resizerConstrains;
    }

    private inIFlasher getIFlasher() {
        if (this.iFlasher == null) {
            nsIServiceManager serviceManager = Mozilla.getInstance().getServiceManager();
            this.iFlasher = (inIFlasher)serviceManager.getServiceByContractID("@mozilla.org/inspector/flasher;1", "{7b4a099f-6f6e-4565-977b-fb622adbff49}");
            this.iFlasher.setThickness(2);
        }
        return this.iFlasher;
    }

    private IXulRunnerVpeResizer getIXulRunnerVpeResizer() {
        if (this.xulRunnerVpeResizer == null) {
            this.xulRunnerVpeResizer = new XulRunnerVpeResizer();
        }
        return this.xulRunnerVpeResizer;
    }

    private boolean checkVisability(nsIDOMNode node) {
        nsIDOMElement domElement;
        try {
            domElement = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        }
        catch (XPCOMException xPCOMException) {
            return false;
        }
        String inlineStyle = domElement.getAttribute(STYLE_ATTR);
        return inlineStyle == null ? true : !PATTERN.matcher(inlineStyle).matches();
    }

    /*
     * Unable to fully structure code
     */
    private nsIDOMElement findVisbleParentElement(nsIDOMElement element) {
        try {
            parentElement = (nsIDOMElement)element.getParentNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            if (true) ** GOTO lbl10
        }
        catch (XPCOMException v0) {
            return null;
        }
        do {
            if (this.checkVisability((nsIDOMNode)parentElement)) {
                return parentElement;
            }
            parentElement = (nsIDOMElement)parentElement.getParentNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
lbl10:
            // 2 sources

        } while (parentElement != null && !this.checkVisability((nsIDOMNode)parentElement));
        return parentElement;
    }

    private void endResizing(int usedHandle, int newTop, int newLeft, int newWidth, int newHeight, nsIDOMElement aResizedObject) {
        this.onElementResize(aResizedObject, usedHandle, newTop, newLeft, newWidth, newHeight);
    }

    public void showResizer() {
        if (this.xulRunnerVpeResizer != null && this.getLastSelectedElement() != null && this.lastResizerConstrains != 0) {
            this.xulRunnerVpeResizer.show(this.getLastSelectedElement(), this.lastResizerConstrains);
        }
    }

    public void hideResizer() {
        if (this.xulRunnerVpeResizer != null) {
            this.xulRunnerVpeResizer.hide();
        }
    }

    public void showSelectionRectangle() {
        if (this.getIFlasher() != null && this.getLastSelectedElement() != null) {
            if (this.scrollRegtangleFlag) {
                this.scrollRegtangleFlag = false;
                this.scrollToElement(this.getLastSelectedElement());
            }
            if (this.checkVisability((nsIDOMNode)this.getLastSelectedElement())) {
                if (this.getLastSelectedElement().getAttribute(VPEFLASHERCOLORATTRIBUTE) == null || !this.getLastSelectedElement().getAttribute(VPEFLASHERCOLORATTRIBUTE).equals(flasherHiddentElementColor)) {
                    this.getIFlasher().setColor(flasherVisialElementColor);
                } else {
                    this.getIFlasher().setColor(flasherHiddentElementColor);
                }
                this.drawElementOutline(this.getLastSelectedElement());
            } else {
                this.getIFlasher().setColor(flasherHiddentElementColor);
                nsIDOMElement domElement = this.findVisbleParentElement(this.getLastSelectedElement());
                if (domElement != null) {
                    this.drawElementOutline(domElement);
                }
            }
        }
    }

    private void scrollToElement(nsIDOMElement element) {
        this.getIFlasher().scrollElementIntoView(element);
    }

    public void addSelectionListener(nsISelectionListener selectionListener) {
        nsISelection selection = this.getSelection();
        nsISelectionPrivate selectionPrivate = (nsISelectionPrivate)selection.queryInterface("{b416c692-eeb8-4186-addd-c444e81b68e5}");
        selectionPrivate.addSelectionListener(selectionListener);
        this.selectionListener = selectionListener;
    }

    public void removeSelectionListener() {
        block3: {
            if (this.selectionListener != null) {
                nsISelection selection = this.getSelection();
                nsISelectionPrivate selectionPrivate = (nsISelectionPrivate)selection.queryInterface("{b416c692-eeb8-4186-addd-c444e81b68e5}");
                try {
                    selectionPrivate.removeSelectionListener(this.selectionListener);
                }
                catch (XPCOMException xpcomException) {
                    if (xpcomException.errorcode == 2147500037L) break block3;
                    throw xpcomException;
                }
            }
        }
        this.selectionListener = null;
    }

    private nsIDOMElement getElement(nsIDOMNode node) {
        if (node != null) {
            if (node.getNodeType() == 1) {
                return (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            }
            if (node.getNodeType() == 3) {
                return (nsIDOMElement)node.getParentNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            }
        }
        return null;
    }

    private void drawElementOutline(nsIDOMElement domElement) {
        if ("macosx".equals(Platform.getOS())) {
            if (this.lastBorderedElement != null && this.lastBorderedElement.getAttribute(STYLE_ATTR) != null) {
                String style = this.lastBorderedElement.getAttribute(PREV_STYLE_ATTR_NAME);
                this.lastBorderedElement.removeAttribute(PREV_STYLE_ATTR_NAME);
                this.lastBorderedElement.setAttribute(STYLE_ATTR, style);
            }
            String oldstyle = domElement.getAttribute(STYLE_ATTR);
            if (flasherHiddentElementColor.equals(this.getIFlasher().getColor())) {
                domElement.setAttribute(STYLE_ATTR, String.valueOf(domElement.getAttribute(STYLE_ATTR)) + ';' + INVISIBLE_ELEMENT_BORDER);
            } else {
                domElement.setAttribute(STYLE_ATTR, String.valueOf(domElement.getAttribute(STYLE_ATTR)) + ';' + VISIBLE_ELEMENT_BORDER);
            }
            this.lastBorderedElement = domElement;
            this.lastBorderedElement.setAttribute(PREV_STYLE_ATTR_NAME, oldstyle);
        } else {
            this.getIFlasher().drawElementOutline(domElement);
        }
    }

    protected void onDispose() {
        this.lastSelectedNode = null;
        this.iFlasher = null;
        super.onDispose();
    }

    private class VisualPaintListener
    implements PaintListener {
        private VisualPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            XulRunnerEditor.this.showSelectionRectangle();
        }
    }
}

