/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.xulrunner.editor.IVpeResizeListener;
import org.jboss.tools.vpe.xulrunner.editor.IXulRunnerVpeResizer;
import org.jboss.tools.vpe.xulrunner.editor.VpeResizerMouseListener;
import org.jboss.tools.vpe.xulrunner.editor.VpeResizerMouseMotionListener;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMElementCSSInlineStyle;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMHTMLDocument;
import org.mozilla.interfaces.nsIDOMHTMLElement;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;

public class XulRunnerVpeResizer
implements IXulRunnerVpeResizer {
    private static final String RESIZER_MARKER_STRING_TOPLEFT = "nw";
    private static final String RESIZER_MARKER_STRING_TOP = "n";
    private static final String RESIZER_MARKER_STRING_TOPRIGHT = "ne";
    private static final String RESIZER_MARKER_STRING_LEFT = "w";
    private static final String RESIZER_MARKER_STRING_RIGHT = "e";
    private static final String RESIZER_MARKER_STRING_BOTTOMLEFT = "sw";
    private static final String RESIZER_MARKER_STRING_BOTTOM = "s";
    private static final String RESIZER_MARKER_STRING_BOTTOMRIGHT = "se";
    private static final int MAX_SIZE = 20000000;
    nsIDOMEventListener mouseListener;
    nsIDOMEventListener mouseMotionListener;
    private ArrayList<IVpeResizeListener> objectResizeEventListeners = new ArrayList();
    private boolean isResizing;
    private int originalX;
    private int originalY;
    private int usedResizeMarker;
    private int incrementFactorX;
    private int incrementFactorY;
    private int incrementFactorWidth;
    private int incrementFactorHeight;
    private nsIDOMElement resizingObject;
    private nsIDOMElement resizingShadow;
    private nsIDOMDocument domDocument;
    private nsIDOMElement activeHandle;
    private Rectangle elementBounds;
    private nsIDOMElement markerTopLeft = null;
    private nsIDOMElement markerTop = null;
    private nsIDOMElement markerTopRight = null;
    private nsIDOMElement markerLeft = null;
    private nsIDOMElement markerRight = null;
    private nsIDOMElement markerBottom = null;
    private nsIDOMElement markerBottomLeft = null;
    private nsIDOMElement markerBottomRight = null;

    public void init(nsIDOMDocument domDocument) {
        this.domDocument = domDocument;
        this.mouseListener = new VpeResizerMouseListener(this);
    }

    public void show(nsIDOMElement domElement, int resizers) {
        if (this.resizingObject != null) {
            this.hide();
        }
        this.resizingObject = domElement;
        this.elementBounds = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
        if (this.elementBounds.width <= 0 || this.elementBounds.width > 20000000 || this.elementBounds.height <= 0 || this.elementBounds.height > 20000000) {
            return;
        }
        nsIDOMElement bodyElement = this.getRootElement();
        if (bodyElement == null) {
            return;
        }
        if ((resizers & 1) == 1) {
            this.markerTopLeft = this.createResizer(RESIZER_MARKER_STRING_TOPLEFT, (nsIDOMNode)bodyElement);
            if (this.markerTopLeft == null) {
                return;
            }
        }
        if ((resizers & 2) == 2) {
            this.markerTop = this.createResizer(RESIZER_MARKER_STRING_TOP, (nsIDOMNode)bodyElement);
            if (this.markerTop == null) {
                return;
            }
        }
        if ((resizers & 4) == 4) {
            this.markerTopRight = this.createResizer(RESIZER_MARKER_STRING_TOPRIGHT, (nsIDOMNode)bodyElement);
            if (this.markerTopRight == null) {
                return;
            }
        }
        if ((resizers & 8) == 8) {
            this.markerLeft = this.createResizer(RESIZER_MARKER_STRING_LEFT, (nsIDOMNode)bodyElement);
            if (this.markerLeft == null) {
                return;
            }
        }
        if ((resizers & 0x10) == 16) {
            this.markerRight = this.createResizer(RESIZER_MARKER_STRING_RIGHT, (nsIDOMNode)bodyElement);
            if (this.markerRight == null) {
                return;
            }
        }
        if ((resizers & 0x20) == 32) {
            this.markerBottomLeft = this.createResizer(RESIZER_MARKER_STRING_BOTTOMLEFT, (nsIDOMNode)bodyElement);
            if (this.markerBottomLeft == null) {
                return;
            }
        }
        if ((resizers & 0x40) == 64) {
            this.markerBottom = this.createResizer(RESIZER_MARKER_STRING_BOTTOM, (nsIDOMNode)bodyElement);
            if (this.markerBottom == null) {
                return;
            }
        }
        if ((resizers & 0x80) == 128) {
            this.markerBottomRight = this.createResizer(RESIZER_MARKER_STRING_BOTTOMRIGHT, (nsIDOMNode)bodyElement);
            if (this.markerBottomRight == null) {
                return;
            }
        }
        this.setAllResizersPosition();
        this.resizingShadow = this.createShadow((nsIDOMNode)bodyElement, this.resizingObject);
        this.setShadowPosition(this.resizingShadow, this.elementBounds.x, this.elementBounds.y);
    }

    public void hide() {
        nsIDOMElement bodyElement = this.getRootElement();
        if (bodyElement == null) {
            return;
        }
        nsIDOMNode parentNode = (nsIDOMNode)bodyElement.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        if (parentNode == null) {
            return;
        }
        if (this.markerTopLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTopLeft);
        }
        if (this.markerTop != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTop);
        }
        if (this.markerTopRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTopRight);
        }
        if (this.markerLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerLeft);
        }
        if (this.markerRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerRight);
        }
        if (this.markerBottomLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottomLeft);
        }
        if (this.markerBottom != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottom);
        }
        if (this.markerBottomRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottomRight);
        }
        if (this.resizingShadow != null) {
            parentNode.removeChild((nsIDOMNode)this.resizingShadow);
        }
        this.markerBottom = null;
        this.markerTop = null;
        this.markerLeft = null;
        this.markerRight = null;
        this.markerBottomRight = null;
        this.markerBottomLeft = null;
        this.markerTopRight = null;
        this.markerTopLeft = null;
        this.resizingShadow = null;
        this.resizingObject = null;
    }

    public void mouseDown(int clientX, int clientY, nsIDOMElement domElement) {
        String anonclass;
        boolean isAnonElement;
        if (domElement != null && (isAnonElement = domElement.hasAttribute("_moz_anonclass")) && (anonclass = domElement.getAttribute("_moz_anonclass")) != null && anonclass.equals("mozResizer")) {
            this.originalX = clientX;
            this.originalY = clientY;
            this.startResizing(domElement);
        }
    }

    public void mouseMove(nsIDOMEvent event) {
        if (this.isResizing) {
            nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
            int clientX = mouseEvent.getClientX();
            int clientY = mouseEvent.getClientY();
            int newX = this.getNewResizingX(clientX, clientY);
            int newY = this.getNewResizingY(clientX, clientY);
            int newWidth = this.getNewResizingWidth(clientX, clientY);
            int newHeight = this.getNewResizingHeight(clientX, clientY);
            this.setStylePropertyPixels(this.resizingShadow, "left", newX);
            this.setStylePropertyPixels(this.resizingShadow, "top", newY);
            this.setStylePropertyPixels(this.resizingShadow, "width", newWidth);
            this.setStylePropertyPixels(this.resizingShadow, "height", newHeight);
        }
    }

    public void mouseUp(int aX, int aY, nsIDOMElement target) {
        if (this.isResizing) {
            this.isResizing = false;
            this.hideShadow();
            this.endResizing(aX, aY);
            nsIDOMEventTarget erP = this.getDOMEventTarget();
            if (erP != null) {
                erP.removeEventListener("mousemove", this.mouseMotionListener, true);
                erP.removeEventListener("mouseup", this.mouseListener, true);
                this.mouseMotionListener = null;
            }
        }
    }

    public void addResizeListener(IVpeResizeListener listener) {
        if (this.objectResizeEventListeners.size() != 0 && this.objectResizeEventListeners.indexOf(listener) != -1) {
            return;
        }
        this.objectResizeEventListeners.add(listener);
    }

    public void removeResizeListener(IVpeResizeListener listener) {
        if (this.objectResizeEventListeners.size() == 0 || this.objectResizeEventListeners.indexOf(listener) == -1) {
            return;
        }
        this.objectResizeEventListeners.remove(listener);
    }

    private void setShadowPosition(nsIDOMElement shadowElement, int aOriginalObjectX, int aOriginalObjectY) {
        this.setAnonymousElementPosition(aOriginalObjectX, aOriginalObjectY, shadowElement);
    }

    private nsIDOMElement createAnonymousElement(String aTag, nsIDOMNode aParentNode, String aAnonClass, boolean isCreatedHidden) {
        nsIDOMElement returnElement = null;
        returnElement = this.domDocument.createElement(aTag);
        if (isCreatedHidden) {
            returnElement.setAttribute("class", "hidden");
        }
        if (aAnonClass.length() != 0) {
            returnElement.setAttribute("_moz_anonclass", aAnonClass);
        }
        aParentNode.appendChild((nsIDOMNode)returnElement);
        return returnElement;
    }

    private nsIDOMElement createShadow(nsIDOMNode parentNode, nsIDOMElement originalObject) {
        nsIDOMElement returnElement = null;
        returnElement = this.createAnonymousElement("span", parentNode, "mozResizingShadow", true);
        return returnElement;
    }

    private void startResizing(nsIDOMElement domElement) {
        this.isResizing = true;
        this.activeHandle = domElement;
        this.activeHandle.setAttribute("_moz_activated", "true");
        String locationStr = this.activeHandle.getAttribute("anonlocation");
        if (locationStr == null) {
            return;
        }
        if (locationStr.equals(RESIZER_MARKER_STRING_TOPLEFT)) {
            this.usedResizeMarker = 1;
            this.setResizeIncrements(1, 1, -1, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_TOP)) {
            this.usedResizeMarker = 2;
            this.setResizeIncrements(0, 1, 0, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_TOPRIGHT)) {
            this.usedResizeMarker = 4;
            this.setResizeIncrements(0, 1, 1, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_LEFT)) {
            this.usedResizeMarker = 8;
            this.setResizeIncrements(1, 0, -1, 0, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_RIGHT)) {
            this.usedResizeMarker = 16;
            this.setResizeIncrements(0, 0, 1, 0, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOMLEFT)) {
            this.usedResizeMarker = 32;
            this.setResizeIncrements(1, 0, -1, 1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOM)) {
            this.usedResizeMarker = 64;
            this.setResizeIncrements(0, 0, 0, 1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOMRIGHT)) {
            this.usedResizeMarker = 128;
            this.setResizeIncrements(0, 0, 1, 1, false);
        }
        this.resizingShadow.removeAttribute("class");
        this.setShadowPosition(this.resizingShadow, this.elementBounds.x, this.elementBounds.y);
        this.setStylePropertyPixels(this.resizingShadow, "width", this.elementBounds.width);
        this.setStylePropertyPixels(this.resizingShadow, "height", this.elementBounds.height);
        if (this.mouseMotionListener != null) {
            return;
        }
        this.mouseMotionListener = new VpeResizerMouseMotionListener(this);
        if (this.mouseMotionListener == null) {
            return;
        }
        nsIDOMEventTarget eventTarget = this.getDOMEventTarget();
        if (eventTarget != null) {
            eventTarget.addEventListener("mousemove", this.mouseMotionListener, true);
            eventTarget.addEventListener("mouseup", this.mouseListener, true);
        }
    }

    private nsIDOMEventTarget getDOMEventTarget() {
        nsIDOMEventTarget eventTarget = (nsIDOMEventTarget)this.domDocument.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        if (eventTarget == null) {
            throw new RuntimeException("nsIDOMEventTarget is null");
        }
        return eventTarget;
    }

    private int getNewResizingX(int aX, int aY) {
        int resized = this.elementBounds.x + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.X) * this.incrementFactorX;
        int max = this.elementBounds.x + this.elementBounds.width;
        return Math.min(resized, max);
    }

    private int getNewResizingY(int aX, int aY) {
        int resized = this.elementBounds.y + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.Y) * this.incrementFactorY;
        int max = this.elementBounds.y + this.elementBounds.height;
        return Math.min(resized, max);
    }

    private int getNewResizingWidth(int aX, int aY) {
        int resized = this.elementBounds.width + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.WIDTH) * this.incrementFactorWidth;
        return Math.max(resized, 1);
    }

    private int getNewResizingHeight(int aX, int aY) {
        int resized = this.elementBounds.height + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.HEIGHT) * this.incrementFactorHeight;
        return Math.max(resized, 1);
    }

    private int getNewResizingIncrement(int aX, int aY, COEFFICIENT_TYPE coefficient_type) {
        int result = 0;
        switch (coefficient_type) {
            case X: 
            case WIDTH: {
                result = aX - this.originalX;
                break;
            }
            case Y: 
            case HEIGHT: {
                result = aY - this.originalY;
            }
        }
        return result;
    }

    private nsIDOMElement getRootElement() {
        nsIDOMHTMLElement htmlBody;
        nsIDOMElement bodyElement = null;
        nsIDOMHTMLDocument htmlDocument = (nsIDOMHTMLDocument)this.domDocument.queryInterface("{a6cf9084-15b3-11d2-932e-00805f8add32}");
        if (htmlDocument != null && (htmlBody = htmlDocument.getBody()) != null) {
            bodyElement = (nsIDOMElement)htmlBody.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        }
        return bodyElement;
    }

    private nsIDOMElement createResizer(String resizerMarkerString, nsIDOMNode parentNode) {
        nsIDOMElement aNewResizer = this.createAnonymousElement("span", parentNode, "mozResizer", false);
        nsIDOMEventTarget evtTarget = (nsIDOMEventTarget)aNewResizer.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        evtTarget.addEventListener("mousedown", this.mouseListener, true);
        aNewResizer.setAttribute("anonlocation", resizerMarkerString);
        return aNewResizer;
    }

    private void setAllResizersPosition() {
        int left = this.elementBounds.x;
        int top = this.elementBounds.y;
        int width = this.elementBounds.width;
        int height = this.elementBounds.height;
        int resizerWidth = 5;
        int resizerHeight = 5;
        int rw = (resizerWidth + 1) / 2;
        int rh = (resizerHeight + 1) / 2;
        if (this.markerTopLeft != null) {
            this.setAnonymousElementPosition(left - resizerWidth - 2, top - resizerHeight - 2, this.markerTopLeft);
        }
        if (this.markerTop != null) {
            this.setAnonymousElementPosition(left + width / 2 - rw, top - resizerHeight - 2, this.markerTop);
        }
        if (this.markerTopRight != null) {
            this.setAnonymousElementPosition(left + width, top - resizerHeight - 2, this.markerTopRight);
        }
        if (this.markerLeft != null) {
            this.setAnonymousElementPosition(left - resizerWidth - 2, top + height / 2 - rh, this.markerLeft);
        }
        if (this.markerRight != null) {
            this.setAnonymousElementPosition(left + width, top + height / 2 - rh, this.markerRight);
        }
        if (this.markerBottomLeft != null) {
            this.setAnonymousElementPosition(left - resizerWidth - 2, top + height, this.markerBottomLeft);
        }
        if (this.markerBottom != null) {
            this.setAnonymousElementPosition(left + width / 2 - rw, top + height, this.markerBottom);
        }
        if (this.markerBottomRight != null) {
            this.setAnonymousElementPosition(left + width, top + height, this.markerBottomRight);
        }
    }

    private void setAnonymousElementPosition(int left, int top, nsIDOMElement domElement) {
        this.setStylePropertyPixels(domElement, "left", left);
        this.setStylePropertyPixels(domElement, "top", top);
    }

    private void setStylePropertyPixels(nsIDOMElement aElement, String aProperty, int aValue) {
        this.setStyle(aElement, aProperty, String.valueOf(aValue) + "px");
    }

    private void setResizeIncrements(int aX, int aY, int aW, int aH, boolean aPreserveRatio) {
        this.incrementFactorX = aX;
        this.incrementFactorY = aY;
        this.incrementFactorWidth = aW;
        this.incrementFactorHeight = aH;
    }

    private void setStyle(nsIDOMElement domElement, String cssPropertyName, String cssPropertyValue) {
        nsIDOMElementCSSInlineStyle inlineStyles = (nsIDOMElementCSSInlineStyle)domElement.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}");
        if (inlineStyles == null) {
            return;
        }
        nsIDOMCSSStyleDeclaration cssDecl = inlineStyles.getStyle();
        if (cssDecl == null) {
            return;
        }
        if (cssPropertyValue.length() == 0) {
            cssDecl.removeProperty(cssPropertyName);
        } else {
            String priority = cssDecl.getPropertyPriority(cssPropertyName);
            cssDecl.setProperty(cssPropertyName, cssPropertyValue, priority);
        }
    }

    private void endResizing(int aClientX, int aClientY) {
        if (this.resizingShadow == null) {
            return;
        }
        if (this.activeHandle != null) {
            this.activeHandle.removeAttribute("_moz_activated");
            this.activeHandle = null;
        }
        int left = this.getNewResizingX(aClientX, aClientY);
        int top = this.getNewResizingY(aClientX, aClientY);
        int width = this.getNewResizingWidth(aClientX, aClientY);
        int height = this.getNewResizingHeight(aClientX, aClientY);
        if (this.objectResizeEventListeners.size() != 0) {
            for (IVpeResizeListener resizeListener : this.objectResizeEventListeners) {
                resizeListener.onEndResizing(this.usedResizeMarker, top, left, width, height, this.resizingObject);
            }
        }
        this.usedResizeMarker = 0;
    }

    private void hideShadow() {
        if (this.resizingShadow != null) {
            this.resizingShadow.setAttribute("class", "hidden");
        }
    }

    public void dispose() {
        nsIDOMEventTarget erP;
        if (this.mouseMotionListener != null && (erP = this.getDOMEventTarget()) != null) {
            erP.removeEventListener("mousemove", this.mouseMotionListener, true);
            erP.removeEventListener("mouseup", this.mouseListener, true);
            this.mouseMotionListener = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum COEFFICIENT_TYPE {
        X,
        Y,
        WIDTH,
        HEIGHT;

    }
}

