/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeEditor
extends BaseFieldEditor
implements PropertyChangeListener {
    List<Control> controls = new ArrayList<Control>();
    List<IFieldEditor> editors = new ArrayList<IFieldEditor>();

    public CompositeEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    @Override
    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)CommonUIMessages.COMPOSITE_EDITOR_PARENT_CONTROL_SHOULD_BE_COMPOSITE);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)CommonUIMessages.COMPOSITE_EDITOR_EDITOR_SUPPORTS_ONLY_GRID_LAYOUT);
        Composite aComposite = (Composite)parent;
        final Control[] controls = (Control[])this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        int i = 0;
        while (i < controls.length) {
            GridData gd = new GridData();
            int n = gd.horizontalSpan = i == 1 ? gl.numColumns - controls.length + 1 : 1;
            if (controls[i] instanceof Combo && i == controls.length - 1) {
                gd.horizontalAlignment = 1;
            } else {
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = i == 1;
            }
            controls[i].setLayoutData((Object)gd);
            controls[i].setEnabled(this.isEnabled());
            if (i == 0) {
                controls[i].addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        CompositeEditor.this.dispose();
                        controls[0].removeDisposeListener((DisposeListener)this);
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public Object[] getEditorControls() {
        if (!this.controls.isEmpty()) {
            return this.controls.toArray();
        }
        throw new IllegalStateException(CommonUIMessages.COMPOSITE_EDITOR_THIS_METOD_CAN_BE_INVOKED);
    }

    @Override
    public Object[] getEditorControls(Object parent) {
        for (IFieldEditor editor : this.editors) {
            this.controls.addAll(Arrays.asList((Control[])editor.getEditorControls(parent)));
        }
        return this.controls.toArray(new Control[0]);
    }

    @Override
    public int getNumberOfControls() {
        return this.editors.size();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public void save(Object object) {
    }

    @Override
    public void setEditable(boolean ediatble) {
    }

    public CompositeEditor addFieldEditors(IFieldEditor[] editors) {
        this.editors.addAll(Arrays.asList(editors));
        for (IFieldEditor editor : Arrays.asList(editors)) {
            editor.addPropertyChangeListener(this);
        }
        return this;
    }

    @Override
    public void setValue(Object newValue) {
        for (IFieldEditor editor : this.editors) {
            editor.removePropertyChangeListener(this);
            editor.setValue(newValue);
            editor.addPropertyChangeListener(this);
        }
        super.setValue(newValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        for (IFieldEditor editor : this.editors) {
            if (event.getSource() == editor) continue;
            editor.removePropertyChangeListener(this);
            editor.setValue(event.getNewValue());
            editor.addPropertyChangeListener(this);
        }
        super.setValue(event.getNewValue());
    }

    @Override
    public void setEnabled(boolean set) {
        for (IFieldEditor editor : this.editors) {
            editor.setEnabled(set);
        }
    }

    public List<IFieldEditor> getEditors() {
        return Collections.unmodifiableList(this.editors);
    }

    public IFieldEditor getEditorByName(String name) {
        for (IFieldEditor editor : this.editors) {
            if (!name.equals(editor.getName())) continue;
            return editor;
        }
        return null;
    }

    @Override
    public void setData(Object key, Object value) {
        super.setData(key, value);
        for (IFieldEditor editor : this.editors) {
            editor.setData(key, value);
        }
    }
}

