/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.common.ui.widget.field.RadioField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioFieldEditor
extends BaseFieldEditor
implements ITaggedFieldEditor,
PropertyChangeListener {
    List values = null;
    List<String> labels;
    RadioField radioField;

    public RadioFieldEditor(String name, String label, List<String> labels, List values, Object defaultValue) {
        super(name, label, defaultValue);
        this.labels = labels;
        this.values = Collections.unmodifiableList(values);
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        return new Control[]{this.getComboControl((Composite)composite)};
    }

    @Override
    public void doFillIntoGrid(Object parent) {
    }

    public Control getComboControl(Composite composite) {
        if (this.radioField == null) {
            this.radioField = new RadioField(composite, this.labels, this.values, this.getValue(), false);
            this.radioField.addPropertyChangeListener(this);
        } else if (composite != null) {
            Assert.isTrue((this.radioField.getControl().getParent() == composite ? 1 : 0) != 0);
        }
        return this.radioField.getControl();
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.radioField.getControl()};
    }

    public void save(Object object) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setValue(evt.getNewValue());
    }

    @Override
    public String[] getTags() {
        String[] result = new String[this.values.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.values.get(0).toString();
            ++i;
        }
        return result;
    }

    @Override
    public void setTags(String[] tags) {
        this.values.clear();
        int i = 0;
        while (i < tags.length) {
            this.values.add(tags[i]);
            ++i;
        }
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue == null) {
            return;
        }
        super.setValue(newValue);
        if (this.radioField != null) {
            this.radioField.removePropertyChangeListener(this);
            this.radioField.setValue(newValue.toString());
            this.radioField.addPropertyChangeListener(this);
        }
    }
}

