/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.field;

import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.widget.field.BaseField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioField
extends BaseField
implements SelectionListener {
    private Composite topComposite;
    private Button[] radios;
    private Object value;

    public RadioField(Composite parent, List<String> labels, List<Object> values, Object defaultValue, boolean verticalLayout) {
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setLayout((Layout)new GridLayout(verticalLayout ? 1 : values.size(), false));
        if (verticalLayout) {
            this.topComposite.setLayoutData((Object)new GridData(768));
        }
        this.radios = new Button[values.size()];
        if (defaultValue == null && !values.isEmpty()) {
            defaultValue = values.get(0);
        }
        int i = 0;
        while (i < this.radios.length) {
            this.radios[i] = new Button(this.topComposite, 16);
            this.radios[i].setText(labels.get(i));
            this.radios[i].addSelectionListener((SelectionListener)this);
            this.radios[i].setLayoutData((Object)new GridData(verticalLayout ? 768 : 1));
            Object value = values.get(i);
            this.radios[i].setData(value);
            if (value != null && value.equals(defaultValue)) {
                this.radios[i].setSelection(true);
                this.value = value;
            }
            ++i;
        }
    }

    @Override
    public Control getControl() {
        return this.topComposite;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        this.value = event.widget.getData();
        this.firePropertyChange("", this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        int i = 0;
        while (i < this.radios.length) {
            if (value.equals(this.radios[i].getData())) {
                this.radios[i].setSelection(true);
            } else {
                this.radios[i].setSelection(false);
            }
            ++i;
        }
    }
}

