/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.text.ext.hyperlink.SeamComponentHyperlink;

public class SeamComponentHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IJavaElement[] elements;
        IFile file;
        IRegion wordRegion;
        SeamELCompletionEngine engine;
        ISeamProject seamProject;
        block31: {
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (region == null || !(textEditor instanceof JavaEditor)) {
                return null;
            }
            int offset = region.getOffset();
            ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
            if (input == null) {
                return null;
            }
            if (input.getResource() == null || input.getResource().getProject() == null) {
                return null;
            }
            seamProject = SeamCorePlugin.getSeamProject((IProject)input.getResource().getProject(), (boolean)true);
            engine = new SeamELCompletionEngine();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
            if (wordRegion == null) {
                return null;
            }
            file = null;
            try {
                IResource resource = input.getCorrespondingResource();
                if (resource instanceof IFile) {
                    file = (IFile)resource;
                }
            }
            catch (JavaModelException javaModelException) {}
            int[] nArray = new int[]{wordRegion.getOffset(), wordRegion.getOffset() + wordRegion.getLength()};
            elements = null;
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if (elements != null) break block31;
            return null;
        }
        try {
            ArrayList<SeamComponentHyperlink> hyperlinks = new ArrayList<SeamComponentHyperlink>();
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotatable annotatable;
                IAnnotation annotation;
                IJavaElement element = iJavaElementArray[n2];
                if (element instanceof IAnnotatable && (annotation = (annotatable = (IAnnotatable)element).getAnnotation("In")) != null) {
                    Set vars;
                    String nameToSearch = element.getElementName();
                    IMemberValuePair[] mvPairs = annotation.getMemberValuePairs();
                    if (mvPairs != null) {
                        IMemberValuePair[] iMemberValuePairArray = mvPairs;
                        int n3 = mvPairs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String name;
                            IMemberValuePair mvPair = iMemberValuePairArray[n4];
                            if ("value".equals(mvPair.getMemberName()) && mvPair.getValue() != null && (name = mvPair.getValue().toString()) != null && name.trim().length() != 0) {
                                nameToSearch = name;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if ((nameToSearch != null || nameToSearch.trim().length() != 0) && (vars = seamProject.getVariables(true)) != null) {
                        for (ISeamContextVariable var : vars) {
                            IBijectedAttribute attr;
                            String resourceName;
                            if (!nameToSearch.equals(var.getName())) continue;
                            while (var instanceof ISeamContextShortVariable) {
                                var = ((ISeamContextShortVariable)var).getOriginal();
                            }
                            if (var == null) continue;
                            if (var instanceof ISeamXmlFactory) {
                                ISeamXmlFactory xmlFactory = (ISeamXmlFactory)var;
                                String value = xmlFactory.getValue();
                                if (value == null || value.trim().length() == 0) {
                                    value = xmlFactory.getMethod();
                                }
                                if (value == null || value.trim().length() == 0) continue;
                                List javaElements = null;
                                try {
                                    javaElements = engine.getJavaElementsForExpression(seamProject, file, value);
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                }
                                catch (BadLocationException badLocationException) {}
                                if (javaElements == null) continue;
                                for (IJavaElement javaElement : javaElements) {
                                    String resourceName2 = null;
                                    if (javaElement.getResource() != null) {
                                        resourceName2 = javaElement.getResource().getName();
                                    }
                                    hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName2, javaElement, nameToSearch));
                                }
                                continue;
                            }
                            if (var instanceof ISeamComponent) {
                                resourceName = null;
                                ISeamComponent comp = (ISeamComponent)var;
                                Set decls = comp.getAllDeclarations();
                                for (ISeamComponentDeclaration decl : decls) {
                                    if (decl.getResource() == null) continue;
                                    resourceName = decl.getResource().getName();
                                    break;
                                }
                                hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (ISeamComponent)var, nameToSearch));
                                continue;
                            }
                            if (var instanceof IRole) {
                                resourceName = null;
                                if (var.getResource() != null) {
                                    resourceName = var.getResource().getName();
                                }
                                hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (IRole)var, nameToSearch));
                                continue;
                            }
                            if (!(var instanceof IBijectedAttribute)) continue;
                            resourceName = null;
                            if (var.getResource() != null) {
                                resourceName = var.getResource().getName();
                            }
                            if ((attr = (IBijectedAttribute)var).getSourceMember() == null) continue;
                            hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (IBijectedAttribute)var, nameToSearch));
                        }
                    }
                }
                ++n2;
            }
            if (hyperlinks != null && !hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }
}

