/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model;

import java.util.Map;
import java.util.TreeMap;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.jst.web.model.tree.WebPagesTree;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;

public class ViewIdsTree
extends WebPagesTree {
    Map<String, XModelObject> pageMap;
    XModelObject root;
    XModelObject webRoot;
    XModelObject pages;

    public void setConstraint(Object object) {
        super.setConstraint(object);
        Object[] os = (Object[])object;
        XModelObject c = (XModelObject)os[1];
        this.root = FileSystemsHelper.getFileSystems((XModel)c.getModel());
        this.webRoot = FileSystemsHelper.getWebRoot((XModel)c.getModel());
        XModelObject f = SeamPagesDiagramStructureHelper.getInstance().getParentFile(c);
        this.pages = f.getChildByPath("Pages");
        XModelObject[] ps = this.pages == null ? new XModelObject[]{} : this.pages.getChildren();
        this.pageMap = new TreeMap<String, XModelObject>();
        int i = 0;
        while (i < ps.length) {
            String viewId = ps[i].getAttributeValue("view id");
            if (viewId != null && viewId.length() != 0 && viewId.indexOf(42) < 0) {
                this.pageMap.put(viewId, ps[i]);
            }
            ++i;
        }
    }

    public XModelObject getRoot() {
        return this.root;
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (object == this.root) {
            if (this.webRoot == null) {
                XModelObject[] rs = super.getChildren(object);
                if (this.pages == null) {
                    return rs;
                }
                XModelObject[] rs1 = new XModelObject[rs.length + 1];
                System.arraycopy(rs, 0, rs1, 0, rs.length);
                rs1[rs.length] = this.pages;
                return rs1;
            }
            if (this.pages == null) {
                return new XModelObject[]{this.webRoot};
            }
            return new XModelObject[]{this.webRoot, this.pages};
        }
        if (object == this.pages) {
            return this.pageMap.values().toArray(new XModelObject[0]);
        }
        return super.getChildren(object);
    }

    public String getValue(XModelObject object) {
        if (this.isLocalPage(object)) {
            return object.getAttributeValue("view id");
        }
        return super.getValue(object);
    }

    public XModelObject find(String value) {
        if (value != null && this.pageMap.containsKey(value)) {
            return this.pageMap.get(value);
        }
        return super.find(value);
    }

    public boolean isSelectable(XModelObject object) {
        if (this.isLocalPage(object)) {
            return true;
        }
        return super.isSelectable(object);
    }

    public boolean hasChildren(XModelObject object) {
        if (this.isLocalPage(object)) {
            return false;
        }
        return super.hasChildren(object);
    }

    private boolean isLocalPage(XModelObject object) {
        return object != null && object.getParent() == this.pages;
    }
}

