/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;

public class DiagramAdopt
implements XAdoptManager,
SeamPagesConstants {
    static String ADOPTABLE_JSP = ".FileJSP.FileHTML.FileXHTML.FileXML.";

    public void adopt(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (this.isAdoptableJSP(target, object)) {
            this.adoptJSP(target, object, p);
        } else if (this.isAdoptableItem(target, object)) {
            this.adoptItem(target, object, p);
        }
    }

    public boolean isAdoptable(XModelObject target, XModelObject object) {
        if (this.isAdoptableJSP(target, object)) {
            return true;
        }
        return this.isAdoptableItem(target, object);
    }

    private boolean isAdoptableJSP(XModelObject target, XModelObject object) {
        String entity = object.getModelEntity().getName();
        if (ADOPTABLE_JSP.indexOf("." + entity + ".") >= 0) {
            String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
            if (target.getModelEntity().getName().startsWith("FileSeamPages")) {
                target = target.getChildByPath("process");
            }
            return SeamPagesDiagramHelper.getHelper(target).getPage(path) == null;
        }
        return false;
    }

    private void adoptJSP(XModelObject target, XModelObject object, Properties p) throws XModelException {
        if (target.getModelEntity().getName().startsWith("FileSeamPages")) {
            target = target.getChildByPath("process");
        }
        this.addRuleByPageAdopt(target, object, p);
    }

    private void addRuleByPageAdopt(XModelObject diagram, XModelObject page, Properties p) throws XModelException {
        String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)page);
        XModelObject pageItem = SeamPagesDiagramHelper.getHelper(diagram).getPage(path);
        if (pageItem != null) {
            return;
        }
        boolean doNotCreateEmptyRule = false;
        pageItem = SeamPagesDiagramHelper.getHelper(diagram).findOrCreateItem(path, null, "page");
        DiagramAdopt.setShape(pageItem, p);
        if (doNotCreateEmptyRule) {
            pageItem.setAttributeValue("persistent", "true");
            pageItem.setModified(true);
        } else {
            XModelObject pages = diagram.getParent().getChildByPath("Pages");
            String suffix = DiagramAdopt.getPageSuffix(diagram.getParent().getModelEntity().getName());
            XModelObject rule = pages.getModel().createModelObject("SeamPage" + suffix, null);
            rule.setAttributeValue("view id", path);
            DefaultCreateHandler.addCreatedObject((XModelObject)pages, (XModelObject)rule, (Properties)p);
        }
    }

    public static String getPageSuffix(String entity) {
        if (entity.endsWith("12")) {
            return "12";
        }
        if (entity.endsWith("20")) {
            return "20";
        }
        if (entity.endsWith("21")) {
            return "21";
        }
        return "22";
    }

    public static void setShape(XModelObject group, Properties p) {
        String y;
        String x = p == null ? null : p.getProperty("mouse.x");
        String string = y = p == null ? null : p.getProperty("mouse.y");
        if (x != null && y != null) {
            group.setAttributeValue("shape", x + "," + y + ",0,0");
        }
    }

    private boolean isAdoptableItem(XModelObject target, XModelObject object) {
        return "SeamPagesDiagramItem".equals(object.getModelEntity().getName());
    }

    private void adoptItem(XModelObject target, XModelObject object, Properties p) {
        p.put("sample", object);
        String type = object.getAttributeValue("type");
        if ("page".equals(type)) {
            XActionInvoker.invoke((String)"CreateActions.AddPageWizard", (XModelObject)target, (Properties)p);
        }
    }
}

