/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.helpers;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.helpers.PageLinks;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.impl.SeamPagesDiagramImpl;

public class SeamPagesPageRefUpdateManager
implements XModelTreeListener,
Runnable,
SeamPagesConstants {
    private static long id = 0L;
    private XModel model;
    private Map<String, PageLinks> pages = new HashMap<String, PageLinks>();
    private int lock = 0;
    protected boolean stopped = false;
    PageUpdateRunnable runnable = new PageUpdateRunnable();

    public static SeamPagesPageRefUpdateManager getInstance(XModel model) {
        SeamPagesPageRefUpdateManager instance = (SeamPagesPageRefUpdateManager)model.getManager("SeamPagesPageRefUpdateManager");
        if (instance == null) {
            instance = new SeamPagesPageRefUpdateManager();
            instance.model = model;
            instance.init();
            model.addManager("SeamPagesPageRefUpdateManager", (Object)instance);
            model.addModelTreeListener((XModelTreeListener)instance);
        }
        return instance;
    }

    private void init() {
    }

    public void updatePage(SeamPagesDiagramHelper h, XModelObject page) {
        PageLinks pl = this.getPageLinks(page);
        if (pl == null) {
            return;
        }
        pl.h = h;
        pl.update();
    }

    PageLinks getPageLinks(XModelObject page) {
        PageLinks pl;
        String pid = page.get("_page_id");
        if (pid == null) {
            pid = "" + ++id;
            page.set("_page_id", pid);
        }
        if ((pl = this.pages.get(pid)) == null) {
            pl = new PageLinks();
            pl.setPage(page);
            this.pages.put(pid, pl);
        }
        return pl;
    }

    public void updateAll() {
        if (this.isLocked()) {
            return;
        }
        this.lock();
        try {
            String[] ks = this.pages.keySet().toArray(new String[0]);
            int i = 0;
            while (i < ks.length) {
                PageLinks pl = this.pages.get(ks[i]);
                if (pl != null) {
                    if (!pl.page.isActive()) {
                        this.pages.remove(ks[i]);
                    } else {
                        pl.update();
                    }
                }
                ++i;
            }
        }
        finally {
            this.unlock();
        }
    }

    public boolean isLocked() {
        return this.lock > 0;
    }

    public void lock() {
        ++this.lock;
    }

    public void unlock() {
        --this.lock;
    }

    public void structureChanged(XModelTreeEvent event) {
        XModel model = event.getModelObject().getModel();
        if (event.kind() == 3 && event.getModelObject() == model.getRoot()) {
            model.removeModelTreeListener((XModelTreeListener)this);
            SeamPagesPageRefUpdateManager instance = (SeamPagesPageRefUpdateManager)model.getManager("JSFPageUpdateManager");
            if (instance != null) {
                instance.stopped = true;
                model.removeManager("JSFPageUpdateManager");
            }
            return;
        }
        if (event.kind() == 1) {
            this.onChildAdded(event);
        }
        if (this.isLocked()) {
            return;
        }
        XJob.addRunnable((XJob.XRunnable)this.runnable);
    }

    private void onChildAdded(XModelTreeEvent event) {
        XModelObject c = (XModelObject)event.getInfo();
        if (!c.getModelEntity().getName().equals("SeamPagesDiagramItem")) {
            return;
        }
        SeamPagesDiagramImpl pi = (SeamPagesDiagramImpl)event.getModelObject();
        PageLinks pl = this.getPageLinks(c);
        if (pl == null || pi.getHelper() == null) {
            return;
        }
        pl.h = pi.getHelper();
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (this.isLocked()) {
            return;
        }
        XJob.addRunnable((XJob.XRunnable)this.runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            SeamPagesPageRefUpdateManager seamPagesPageRefUpdateManager = this;
            synchronized (seamPagesPageRefUpdateManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.stopped) break;
            if (this.isLocked()) continue;
            this.updateAll();
        }
    }

    class PageUpdateRunnable
    implements XJob.XRunnable {
        PageUpdateRunnable() {
        }

        public String getId() {
            return "Seam Pages Reference Update -" + XModelConstants.getWorkspace((XModel)SeamPagesPageRefUpdateManager.this.model);
        }

        public void run() {
            if (!SeamPagesPageRefUpdateManager.this.isLocked()) {
                SeamPagesPageRefUpdateManager.this.updateAll();
            }
        }
    }
}

