/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.components.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SeamNamespaces {
    private static Map<String, SeamNamespaces> map = new HashMap<String, SeamNamespaces>();
    String versionSuffix = null;
    private Map<String, String> namespaceToURI = new HashMap<String, String>();
    private Map<String, String> uriToNamespace = new HashMap<String, String>();
    private Map<String, String> namespaceToSchema = new HashMap<String, String>();
    static String XMLNS_PREFIX = "xmlns:";

    public static SeamNamespaces getInstance(XModelMetaData meta, String version) {
        SeamNamespaces instance = map.get(version);
        if (instance == null) {
            instance = new SeamNamespaces(meta, version);
        }
        return instance;
    }

    private SeamNamespaces(XModelMetaData meta, String versionSuffix) {
        String v;
        XMapping m = meta.getMapping("SeamNamespaces");
        if (m == null) {
            return;
        }
        this.versionSuffix = versionSuffix;
        String[] keys = m.getKeys();
        int i = 0;
        while (i < keys.length) {
            v = m.getValue(keys[i]);
            this.namespaceToURI.put(keys[i], v);
            this.uriToNamespace.put(v, keys[i]);
            ++i;
        }
        m = meta.getMapping("SeamSchemas");
        if (m == null) {
            return;
        }
        keys = m.getKeys();
        i = 0;
        while (i < keys.length) {
            if (keys[i].endsWith(versionSuffix)) {
                v = m.getValue(keys[i]);
                String key = keys[i].substring(0, keys[i].length() - versionSuffix.length());
                this.namespaceToSchema.put(key, v);
            }
            ++i;
        }
    }

    public NamespaceMapping getNamespaceMapping(Element element) {
        NamespaceMapping mapping = new NamespaceMapping();
        NamedNodeMap as = element.getAttributes();
        int i = 0;
        while (i < as.getLength()) {
            Node n = as.item(i);
            String name = n.getNodeName();
            if (name.startsWith(XMLNS_PREFIX)) {
                String actualNamespace = name.substring(XMLNS_PREFIX.length());
                String uri = n.getNodeValue();
                String defaultNamespace = this.getDefaultNamespace(uri);
                if (defaultNamespace != null) {
                    mapping.addNamespace(defaultNamespace, actualNamespace, uri);
                }
            }
            ++i;
        }
        return mapping;
    }

    public String getDefaultNamespace(String uri) {
        return this.uriToNamespace.get(uri);
    }

    public String getURI(String namespace) {
        return this.namespaceToURI.get(namespace);
    }

    public String getSchema(String namespace) {
        return this.namespaceToSchema.get(namespace);
    }

    public void validateNamespaces(XModelObject object, Element element) {
        NamespaceMapping namespaceMapping = NamespaceMapping.load((XModelObject)object);
        if (namespaceMapping == null) {
            namespaceMapping = new NamespaceMapping();
        }
        StringBuffer loc = new StringBuffer();
        loc.append(object.getAttributeValue("xsi:schemaLocation"));
        XModelObject[] cs = object.getChildren();
        HashSet<String> ns = new HashSet<String>();
        int i = 0;
        while (i < cs.length) {
            String defaultNamespace;
            String n = cs[i].getModelEntity().getXMLSubPath();
            int k = n.indexOf(58);
            if (k >= 0 && !ns.contains(defaultNamespace = n.substring(0, k))) {
                ns.add(defaultNamespace);
                String uri = this.getURI(defaultNamespace);
                if (uri != null) {
                    String actualNamespace = namespaceMapping.getActualNamespace(defaultNamespace);
                    if (actualNamespace == null) {
                        actualNamespace = defaultNamespace;
                    }
                    element.setAttribute(String.valueOf(XMLNS_PREFIX) + actualNamespace, uri);
                    String schema = this.getSchema(defaultNamespace);
                    if (loc.indexOf(uri) < 0) {
                        loc.append(' ').append(uri).append(' ').append(schema);
                    }
                }
            }
            ++i;
        }
        object.setAttributeValue("xsi:schemaLocation", loc.toString());
    }
}

