/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.components.model.helpers;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.seam.xml.SeamXMLMessages;

public class OpenRuleHelper {
    public String run(XModel model, IFile jsp, String action) {
        if (model == null || jsp == null || action == null) {
            return null;
        }
        XModelObject jspObject = EclipseResourceUtil.getObjectByResource((IResource)jsp);
        if (jspObject == null) {
            return null;
        }
        WebProject p = WebProject.getInstance((XModel)model);
        String jspLocation = jsp.getLocation().toString().replace('\\', '/');
        String webRoot = p.getWebRootLocation().replace('\\', '/');
        if (webRoot.endsWith("/")) {
            webRoot = webRoot.substring(0, webRoot.length() - 1);
        }
        if (!jspLocation.startsWith(webRoot)) {
            return null;
        }
        String viewPath = jspLocation.substring(webRoot.length());
        XModelObject result = this.findRule(model, viewPath, action);
        if (result == null) {
            return NLS.bind((String)SeamXMLMessages.CANNOT_FIND_MATCHING_RULE_FOR_PATH, (Object)viewPath);
        }
        XModelObject object = result;
        XAction xaction = XActionInvoker.getAction((String)"Select", (XModelObject)object);
        if (xaction != null && xaction.isEnabled(object)) {
            XActionInvoker.invoke((String)"Select", (XModelObject)object, (Properties)new Properties());
        }
        return null;
    }

    private XModelObject findRule(XModel model, String viewPath, String action) {
        XModelObject webinf = FileSystemsHelper.getWebInf((XModel)model);
        if (webinf == null) {
            return null;
        }
        XModelObject pagesXML = webinf.getChildByPath("pages.xml");
        if (pagesXML == null) {
            return null;
        }
        XModelObject pagesFolder = pagesXML.getChildByPath("Pages");
        XModelObject[] ps = pagesFolder.getChildren();
        int i = 0;
        while (i < ps.length) {
            String viewId = ps[i].getAttributeValue("view id");
            if (OpenRuleHelper.isPatternMatches(viewId, viewPath)) {
                XModelObject[] ns = ps[i].getChildren();
                int j = 0;
                while (j < ns.length) {
                    String entity = ns[j].getModelEntity().getName();
                    if (entity.startsWith("SeamPageNavigation") && !entity.startsWith("SeamPageNavigationRule")) {
                        XModelObject[] rs = ns[j].getChildren();
                        int k = 0;
                        while (k < rs.length) {
                            String a = rs[k].getAttributeValue("if outcome");
                            if (a != null && a.equals(action)) {
                                return rs[k];
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isPatternMatches(String pattern, String fromViewId) {
        if (pattern.length() == 0 || "*".equals(pattern)) {
            return true;
        }
        pattern = pattern.toLowerCase().replace('\\', '/');
        fromViewId = fromViewId.toLowerCase().replace('\\', '/');
        if (pattern.indexOf(42) < 0) {
            return pattern.equals(fromViewId);
        }
        StringTokenizer st = new StringTokenizer(pattern, "*", true);
        boolean f = true;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if ("*".equals(t)) {
                f = false;
                continue;
            }
            int i = fromViewId.indexOf(t);
            if (i < 0 || f && i > 0) {
                return false;
            }
            fromViewId = fromViewId.substring(i);
        }
        return true;
    }
}

