/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor;

import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.SelectionUtil;

public class PagesContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private MouseEvent lastDownEvent = null;

    public PagesContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PagesContextMenuProvider.this.lastDownEvent = e;
            }
        });
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager manager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
    }

    ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    private void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void update(boolean force, boolean recursive) {
        if (!this.isDirty() && !force) {
            return;
        }
        if (!this.menuExist()) {
            return;
        }
        MenuItem[] is = this.getMenu().getItems();
        int i = 0;
        while (i < is.length) {
            if (!is[i].isDisposed()) {
                is[i].dispose();
            }
            ++i;
        }
        ISelection s = this.getViewer().getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        XModelObject object = SelectionUtil.getTarget(ss.getFirstElement());
        if (object != null) {
            String entityName = object.getModelEntity().getName();
            if (entityName.equals("SeamPagesDiagramItemOutput") && object instanceof ReferenceObject && ((ReferenceObject)object).getReference() == null) {
                entityName = "SeamPagesDiagramItemOutputVirtual_ActionList";
            } else if (entityName.equals("SeamPagesDiagramItem") && object instanceof ReferenceObject && ((ReferenceObject)object).getReference() == null) {
                entityName = "SeamPagesDiagramItemVirtual_ActionList";
            }
            PagesDiagramEditPart part = (PagesDiagramEditPart)this.getViewer().getRootEditPart().getChildren().get(0);
            Properties p = new Properties();
            if (this.lastDownEvent != null) {
                Point point = new Point(this.lastDownEvent.x, this.lastDownEvent.y);
                part.getFigure().translateToRelative((Translatable)point);
                p.setProperty("mouse.x", "" + point.x);
                p.setProperty("mouse.y", "" + point.y);
                this.lastDownEvent = null;
            }
            p.put("diagramEditPart", part);
            XModelEntity entity = object.getModel().getMetaData().getEntity(entityName);
            if (entity == null) {
                return;
            }
            XModelObjectActionList list = new XModelObjectActionList(entity.getActionList(), object, SelectionUtil.getTargets(ss), (Object)new Object[]{object, p});
            Menu menu = this.getMenu();
            list.createMenu(menu);
            list.removeLastSeparator(menu);
        }
    }
}

