/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.jboss.tools.common.editor.AbstractSectionEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.jst.web.model.WebProcess;
import org.jboss.tools.seam.ui.pages.SeamUiPagesPlugin;
import org.jboss.tools.seam.ui.pages.editor.PagesEditor;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesFactory;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModel;

public class SeamPagesGuiEditor
extends AbstractSectionEditor {
    private PagesEditor gui = null;
    private IModelObjectEditorInput input;
    private boolean isInitialized = false;
    private XModelObject diagramXML = null;
    private PagesModel model;

    public void dispose() {
        if (this.model == null) {
            return;
        }
        this.model.dispose();
        this.model = null;
        this.gui.dispose();
        this.disposeGui();
        this.gui = null;
        this.input = null;
        this.diagramXML = null;
        super.dispose();
    }

    public PagesEditor getGUI() {
        return this.gui;
    }

    protected boolean isWrongEntity(String entity) {
        return !entity.startsWith("FileSeamPages");
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.input = (IModelObjectEditorInput)input;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.gui == null ? null : this.gui.getModelSelectionProvider();
    }

    protected XModelObject getDiagramXML() {
        return this.diagramXML;
    }

    private WebProcess findDiagramXML() {
        XModelObject o1 = this.input.getXModelObject();
        if (o1 == null) {
            return null;
        }
        XModelObject c = o1.getChildByPath("process");
        if (!(c instanceof WebProcess)) {
            return null;
        }
        WebProcess f = (WebProcess)c;
        return !f.isPrepared() ? null : f;
    }

    protected void updateGui() {
        WebProcess f = this.findDiagramXML();
        if (f != this.diagramXML) {
            this.disposeGui();
        } else if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.diagramXML = f;
        this.guiControl.setVisible(f != null);
        if (f == null) {
            return;
        }
        try {
            f.autolayout();
            this.gui = new PagesEditor((IEditorInput)this.input);
            this.model = this.createModel();
            this.gui.setPagesModel(this.model);
            this.gui.init((IEditorSite)this.getSite(), (IEditorInput)this.input);
            this.gui.createPartControl(this.guiControl);
            this.control = this.guiControl.getChildren()[0];
            this.control.setLayoutData((Object)new GridData(1808));
            this.guiControl.layout();
            this.wrapper.update();
            this.wrapper.layout();
        }
        catch (CoreException ex) {
            SeamUiPagesPlugin.getDefault().logError(ex);
        }
    }

    private PagesModel createModel() {
        PagesModel model = PagesFactory.eINSTANCE.createPagesModel();
        model.setData(this.diagramXML);
        model.load();
        return model;
    }

    public Object getAdapter(Class adapter) {
        if ((adapter == ActionRegistry.class || adapter == ZoomManager.class) && this.getGUI() != null) {
            return this.getGUI().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public String getTitle() {
        return "Diagram";
    }
}

