/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.dnd;

import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.seam.ui.pages.SeamUiPagesPlugin;

public class DndHelper {
    public static boolean drag(Object source) {
        if (source == null) {
            return false;
        }
        XAction copy = DnDUtil.getEnabledAction((XModelObject)((XModelObject)source), null, (String)"CopyActions.Copy");
        if (copy == null) {
            return false;
        }
        XModelTransferBuffer.getInstance().enable();
        Properties properties = new Properties();
        properties.setProperty("isDrop", "true");
        properties.setProperty("isDrag", "true");
        properties.setProperty("actionSourceGUIComponentID", "editor");
        try {
            copy.executeHandler((XModelObject)source, properties);
        }
        catch (XModelException e) {
            SeamUiPagesPlugin.getDefault().logError(e);
            XModelTransferBuffer.getInstance().disable();
            return false;
        }
        return true;
    }

    public static void dragEnd() {
        XModelTransferBuffer.getInstance().disable();
    }

    public static void drop(Object target, Point point) {
        if (target == null) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("isDrop", "true");
        properties.setProperty("actionSourceGUIComponentID", "editor");
        if (point != null) {
            properties.put("mouse.x", "" + point.x);
            properties.put("mouse.y", "" + point.y);
        }
        try {
            DnDUtil.paste((XModelObject)((XModelObject)target), (Properties)properties);
        }
        catch (XModelException ex) {
            SeamUiPagesPlugin.getDefault().logError(ex);
        }
    }

    public static void drop(Object target) {
        DndHelper.drop(target, null);
    }

    public static boolean isDropEnabled(Object target) {
        return DnDUtil.isPasteEnabled((XModelObject)((XModelObject)target));
    }
}

