/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.MouseEvent;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.ui.pages.editor.dnd.DndHelper;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Link;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.edit.LinkEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesConnectionHandle;
import org.jboss.tools.seam.ui.pages.editor.figures.ConnectionFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.FigureFactory;

public class LinkEndpointEditPolicy
extends ConnectionEndpointEditPolicy {
    private List handles = null;

    private void addPagesHandles() {
        this.removePagesHandles();
        this.handles = this.createHandles();
        IFigure layer = this.getLayer("Handle Layer");
        int i = 0;
        while (i < this.handles.size()) {
            layer.add((IFigure)this.handles.get(i));
            ++i;
        }
    }

    private void removePagesHandles() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        int i = 0;
        while (i < this.handles.size()) {
            layer.remove((IFigure)this.handles.get(i));
            ++i;
        }
        this.handles = null;
    }

    protected void addSelectionHandles() {
        PagesElement page = null;
        Link link = ((LinkEditPart)this.getHost()).getLinkModel();
        if (link != null && link.getFromElement() instanceof Page) {
            page = (Page)link.getFromElement();
        }
        if (page == null || page.getData() == null || !(page.getData() instanceof ReferenceObject) || ((ReferenceObject)page.getData()).getReference() != null) {
            super.addSelectionHandles();
        }
        this.addPagesHandles();
        this.getConnectionFigure().setForegroundColor(FigureFactory.selectedColor);
    }

    protected ConnectionFigure getConnectionFigure() {
        return (ConnectionFigure)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected void removeSelectionHandles() {
        super.removeSelectionHandles();
        this.removePagesHandles();
        this.getConnectionFigure().setForegroundColor(FigureFactory.normalColor);
    }

    protected List createSelectionHandles() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        list.add(new LinkEndHandle((ConnectionEditPart)this.getHost()));
        list.add(new LinkStartHandle((ConnectionEditPart)this.getHost()));
        return list;
    }

    protected List createHandles() {
        ArrayList<PagesConnectionHandle> list = new ArrayList<PagesConnectionHandle>();
        ConnectionFigure conn = this.getConnectionFigure();
        boolean flag = true;
        int i = 0;
        while (i < conn.getPoints().size() - 3) {
            flag = !flag;
            list.add(new PagesConnectionHandle((ConnectionEditPart)this.getHost(), flag, i + 1));
            ++i;
        }
        return list;
    }

    class LinkEndHandle
    extends ConnectionHandle {
        public LinkEndHandle(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public LinkEndHandle(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 3));
        }

        public LinkEndHandle() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            LinkEndpointTracker tracker = new LinkEndpointTracker((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection target");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }

    class LinkEndpointTracker
    extends ConnectionEndpointTracker {
        public LinkEndpointTracker(ConnectionEditPart cpart) {
            super(cpart);
        }

        public void mouseDown(MouseEvent me, EditPartViewer epv) {
            super.mouseDown(me, epv);
            LinkEndpointEditPolicy.this.removePagesHandles();
            DndHelper.drag(((Link)LinkEndpointEditPolicy.this.getHost().getModel()).getData());
        }

        public void mouseUp(MouseEvent me, EditPartViewer epv) {
            super.mouseUp(me, epv);
            if (LinkEndpointEditPolicy.this.getHost().getSelected() != 0) {
                LinkEndpointEditPolicy.this.addPagesHandles();
            }
        }

        protected boolean handleNativeDragFinished(DragSourceEvent event) {
            DndHelper.dragEnd();
            return false;
        }
    }

    class LinkStartHandle
    extends ConnectionHandle {
        public LinkStartHandle(ConnectionEditPart owner) {
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public LinkStartHandle(ConnectionEditPart owner, boolean fixed) {
            super(fixed);
            this.setOwner((GraphicalEditPart)owner);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), 2));
        }

        public LinkStartHandle() {
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            LinkEndpointTracker tracker = new LinkEndpointTracker((ConnectionEditPart)this.getOwner());
            tracker.setCommandName("Reconnection source");
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

