/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Param;
import org.jboss.tools.seam.ui.pages.editor.edit.ParamEditPart;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.ParamListFigure;

public class ParamFigure
extends NodeFigure
implements HandleBounds {
    private static final Dimension SIZE = new Dimension(56, 100);
    public static final Font nameParamFont = new Font(null, "default", 8, 1);
    public static final Font valueParamFont = new Font(null, "default", 8, 0);
    private static final Color selectionColor = new Color(null, 65, 119, 160);
    public Param param;
    ParamEditPart editPart;

    public void setEditPart(ParamEditPart part) {
        this.editPart = part;
    }

    public ParamFigure(Param group) {
        this.param = group;
        this.setOpaque(true);
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    private int getTextWidth() {
        return 90;
    }

    private int getTextInset() {
        return 5;
    }

    protected void paintFigure(Graphics g) {
        String name;
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        if (this.editPart.getSelected() == 2 || this.editPart.getSelected() == 1) {
            g.setBackgroundColor(selectionColor);
            g.setForegroundColor(ColorConstants.white);
            g.fillRectangle(1, 1, r.width - 2, r.height - 2);
        } else {
            g.setBackgroundColor(lightGrayColor);
            g.setForegroundColor(ColorConstants.black);
            g.fillRectangle(1, 1, r.width - 2, r.height - 2);
        }
        if (this.param.getName() != null) {
            name = this.param.getName();
            name = String.valueOf(name) + ":";
        } else {
            name = "Param:";
        }
        String value = this.param.getValue() != null ? this.param.getValue() : "value";
        if (this.param != null) {
            g.setFont(nameParamFont);
            g.drawString(name, this.getTextInset(), 2);
            g.setFont(valueParamFont);
            g.drawString(value, ((ParamListFigure)this.getParent()).getNameWidth() + 3 * this.getTextInset(), 2);
        }
    }
}

