/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class WorkaroundFor207146
implements IStartup {
    public void earlyStartup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WebContentUpdater(), 1);
    }

    public static class ManifestChangeDetector
    implements IResourceDeltaVisitor {
        boolean skip = false;

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.skip) {
                return false;
            }
            IPath location = delta.getResource().getLocation();
            if (location == null) {
                return false;
            }
            if ("MANIFEST.MF".equals(location.lastSegment()) || "META-INF".equals(location.lastSegment())) {
                this.skip = true;
                return false;
            }
            return true;
        }
    }

    public static class WebContentUpdater
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] delta;
            if (event.getType() != 1 || event.getDelta() == null) {
                return;
            }
            ManifestChangeDetector visitor = new ManifestChangeDetector();
            try {
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            if (visitor.skip) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = delta = event.getDelta().getAffectedChildren();
            int n = delta.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                IProject prj = resourceDelta.getResource().getProject();
                IVirtualComponent comp = ComponentCore.createComponent((IProject)prj);
                if (comp != null) {
                    IVirtualFolder root = comp.getRootFolder();
                    IResourceDelta foundMember = event.getDelta().findMember(root.getUnderlyingFolder().getFullPath());
                    if (foundMember != null) {
                        this.refreshPackageExplorer();
                        return;
                    }
                }
                ++n2;
            }
        }

        private void refreshPackageExplorer() {
            Display display = Display.getDefault();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                public void run() {
                    TreeViewer tv;
                    PackageExplorerPart p = PackageExplorerPart.getFromActivePerspective();
                    if (p != null && (tv = p.getTreeViewer()) != null) {
                        tv.refresh();
                    }
                }
            });
        }
    }
}

