/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.model.ui.texteditors.xmleditor.XMLTextEditor;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.search.SeamSearchQuery;
import org.jboss.tools.seam.ui.search.SeamSearchScope;

public abstract class FindSeamAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2,
ISelectionListener {
    IAction fDelegatorAction = null;

    protected FindSeamAction() {
    }

    public void run() {
        this.runWithEvent(null);
    }

    private IEditorPart getCurrentEditor(IWorkbenchWindow window) {
        if (window == null || window.getActivePage() == null) {
            return null;
        }
        return window.getActivePage().getActiveEditor();
    }

    private ISourceViewer getEditorViewer(IWorkbenchPart editor) {
        StructuredTextViewer viewer = null;
        if (editor instanceof EditorPartWrapper) {
            editor = ((EditorPartWrapper)editor).getEditor();
        }
        if (editor instanceof JSPMultiPageEditor) {
            viewer = ((JSPMultiPageEditor)editor).getJspEditor().getTextViewer();
        } else if (editor instanceof XMLTextEditor) {
            viewer = ((XMLTextEditor)editor).getTextViewer();
        } else if (editor instanceof MultiPageEditorPart) {
            IEditorPart activeEditor = FindSeamAction.getActiveEditor((MultiPageEditorPart)editor);
            if (activeEditor instanceof AbstractTextEditor) {
                viewer = FindSeamAction.getSourceViewer((AbstractTextEditor)activeEditor);
            }
        } else if (editor instanceof AbstractTextEditor) {
            viewer = FindSeamAction.getSourceViewer((AbstractTextEditor)editor);
        } else if (editor instanceof CompilationUnitEditor) {
            viewer = ((CompilationUnitEditor)editor).getViewer();
        }
        return viewer;
    }

    private ITextSelection getTextSelection(ITextViewer viewer) {
        if (viewer == null || viewer.getSelectionProvider() == null) {
            return null;
        }
        return this.getTextSelection(viewer.getSelectionProvider().getSelection());
    }

    private ITextSelection getTextSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    public void runWithEvent(Event e) {
        IProject project;
        ISeamProject seamProject;
        IEditorPart activeWorkbenchPart = this.getCurrentEditor(this.getActiveWorkbenchWindow());
        if (activeWorkbenchPart == null) {
            return;
        }
        IEditorInput input = activeWorkbenchPart instanceof IEditorPart ? activeWorkbenchPart.getEditorInput() : null;
        ISourceViewer viewer = this.getEditorViewer((IWorkbenchPart)activeWorkbenchPart);
        if (viewer == null) {
            return;
        }
        ITextSelection selection = this.getTextSelection((ITextViewer)viewer);
        if (selection == null) {
            return;
        }
        int selectionOffset = selection.getOffset();
        IDocument document = viewer.getDocument();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        if ((seamProject = SeamCorePlugin.getSeamProject((IProject)(project = file == null ? null : file.getProject()), (boolean)true)) == null) {
            return;
        }
        ELInvocationExpression expression = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)selectionOffset, (int)0, (int)document.getLength());
        if (expression == null) {
            return;
        }
        try {
            this.performNewSearch(expression, file);
        }
        catch (JavaModelException jme) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)jme);
        }
        catch (InterruptedException ie) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ie);
        }
    }

    public static String[] findVariableNames(ISeamProject seamProject, IDocument document, ELInvocationExpression tokens) {
        String[] varNames = null;
        if (tokens == null) {
            return varNames;
        }
        ArrayList variables = new ArrayList();
        while (tokens != null) {
            try {
                int start = tokens.getStartPosition();
                int end = tokens.getEndPosition();
                String variationText = document.get(start, end - start);
                Set vars = seamProject.getVariablesByName(variationText);
                if (vars != null) {
                    variables.addAll(vars);
                }
            }
            catch (BadLocationException e1) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)e1);
            }
            tokens = tokens.getLeft();
        }
        if (!variables.isEmpty()) {
            varNames = new String[variables.size()];
            int i = 0;
            while (i < variables.size()) {
                varNames[i] = ((ISeamContextVariable)variables.get(i)).getName();
                ++i;
            }
        }
        return varNames;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectionChanged((IWorkbenchPart)this.getCurrentEditor(this.getActiveWorkbenchWindow()), selection);
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void init(IAction action) {
        this.fDelegatorAction = action;
    }

    private SeamSearchQuery createQuery(ELInvocationExpression tokens, IFile sourceFile) throws JavaModelException, InterruptedException {
        SeamSearchScope scope = new SeamSearchScope((IResource[])new IProject[]{sourceFile.getProject()}, this.getLimitTo());
        return new SeamSearchQuery(tokens, sourceFile, scope);
    }

    protected abstract int getLimitTo();

    private void performNewSearch(ELInvocationExpression expression, IFile sourceFile) throws JavaModelException, InterruptedException {
        SeamSearchQuery query = this.createQuery(expression, sourceFile);
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground((Object)query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, (Object)query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    public static IEditorPart getActiveEditor(MultiPageEditorPart multiPageEditor) {
        Class<?> editorClass = multiPageEditor.getClass();
        while (editorClass != null) {
            try {
                Method m = editorClass.getDeclaredMethod("getActiveEditor", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    Object result = m.invoke((Object)multiPageEditor, new Object[0]);
                    return result instanceof IEditorPart ? (IEditorPart)result : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            editorClass = editorClass.getSuperclass();
        }
        return null;
    }

    public static ISourceViewer getSourceViewer(AbstractTextEditor editor) {
        Class<?> editorClass = editor.getClass();
        while (editorClass != null) {
            try {
                Method m = editorClass.getDeclaredMethod("getSourceViewer", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    Object result = m.invoke((Object)editor, new Object[0]);
                    return result instanceof ISourceViewer ? (ISourceViewer)result : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            editorClass = editorClass.getSuperclass();
        }
        return null;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return this.getWorkbench() == null ? null : this.getWorkbench().getActiveWorkbenchWindow();
    }

    private void update(ISelection selection) {
        boolean enabled = false;
        try {
            IEditorPart activeWorkbenchPart = this.getCurrentEditor(this.getActiveWorkbenchWindow());
            if (!(activeWorkbenchPart instanceof IEditorPart)) {
                return;
            }
            ISourceViewer viewer = this.getEditorViewer((IWorkbenchPart)activeWorkbenchPart);
            if (viewer == null) {
                return;
            }
            enabled = this.getTextSelection(selection) != null;
        }
        finally {
            this.setEnabled(enabled);
            if (this.fDelegatorAction != null) {
                this.fDelegatorAction.setEnabled(enabled);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update((ISelection)this.getTextSelection((ITextViewer)this.getEditorViewer(part)));
    }
}

