/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.SeamUiImages;
import org.jboss.tools.seam.ui.actions.FindSeamAction;
import org.jboss.tools.seam.ui.handlers.FindSeamDeclarationsHandler;
import org.jboss.tools.seam.ui.handlers.FindSeamReferencesHandler;

public class SeamFindQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ISeamProject seamProject = this.getSeamProject(context);
        if (seamProject == null) {
            return false;
        }
        IDocument document = this.getDocument(context.getCompilationUnit());
        int start = 0;
        int end = document.getLength();
        ASTNode node = context.getCoveringNode();
        System.out.println("Covering node=" + node);
        String[] varNames = this.getVariableNames(seamProject, document, context.getSelectionOffset(), start, end);
        return varNames != null && varNames.length != 0;
    }

    private ISeamProject getSeamProject(IInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        IResource javaFile = cu.getResource();
        if (javaFile == null) {
            return null;
        }
        return SeamCorePlugin.getSeamProject((IProject)javaFile.getProject(), (boolean)true);
    }

    private String[] getVariableNames(ISeamProject seamProject, IDocument document, int offset, int start, int end) {
        SeamELCompletionEngine engine = new SeamELCompletionEngine();
        ELInvocationExpression tokens = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)offset, (int)start, (int)end);
        if (tokens == null) {
            return null;
        }
        return FindSeamAction.findVariableNames(seamProject, document, tokens);
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        IJavaCompletionProposal[] result = new IJavaCompletionProposal[]{};
        if (!this.hasAssists(context)) {
            return result;
        }
        IDocument document = this.getDocument(context.getCompilationUnit());
        try {
            String contents = document.get(context.getSelectionOffset(), context.getSelectionLength());
            String searchString = "";
            ISeamProject seamProject = this.getSeamProject(context);
            if (seamProject == null) {
                return result;
            }
            ELInvocationExpression tokens = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)context.getSelectionOffset(), (int)0, (int)document.getLength());
            if (tokens == null) {
                return result;
            }
            searchString = tokens.getText();
            result = new IJavaCompletionProposal[]{new ExternalActionQuickAssistProposal(contents, SeamUiImages.getImage("find_seam_declarations.gif"), Messages.format((String)SeamUIMessages.SeamQuickFixFindDeclarations, (Object[])new Object[]{searchString}), context){

                public void apply(IDocument target) {
                    try {
                        new FindSeamDeclarationsHandler().execute(null);
                    }
                    catch (ExecutionException e) {
                        SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }, new ExternalActionQuickAssistProposal(contents, SeamUiImages.getImage("find_seam_references.gif"), Messages.format((String)SeamUIMessages.SeamQuickFixFindReferences, (Object[])new Object[]{searchString}), context){

                public void apply(IDocument target) {
                    try {
                        new FindSeamReferencesHandler().execute(null);
                    }
                    catch (ExecutionException e) {
                        SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }};
        }
        catch (BadLocationException e) {
            SeamGuiPlugin.getPluginLog().logError("Could not get document contents for Seam Find Quick Assist", (Throwable)e);
        }
        return result;
    }

    private IDocument getDocument(ICompilationUnit cu) throws JavaModelException {
        IFile file = (IFile)cu.getResource();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(file));
        if (document == null) {
            return new Document(cu.getSource());
        }
        return document;
    }

    public abstract class ExternalActionQuickAssistProposal
    implements IJavaCompletionProposal {
        private String contents;
        private ICompletionProposal proposal;

        public ExternalActionQuickAssistProposal(String contents, Image image, String description, IInvocationContext context) {
            this.contents = contents;
            this.proposal = new CompletionProposal("", context.getSelectionLength(), 0, context.getSelectionOffset() + context.getSelectionLength(), image, description, null, null);
        }

        public String getContents() {
            return this.contents;
        }

        public String getName() {
            return null;
        }

        public int getRelevance() {
            return 0;
        }

        public abstract void apply(IDocument var1);

        public String getAdditionalProposalInfo() {
            return this.proposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.proposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.proposal.getDisplayString();
        }

        public Image getImage() {
            return this.proposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return this.proposal.getSelection(document);
        }
    }
}

