/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.reveng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TablesColumnsCollector {
    public static final long LOWER_MASK = 0xFFFFFFFFL;
    public static final long UPPER_MASK = -4294967296L;
    protected boolean fullStructure = false;
    protected List catalogs;
    protected List schemas;
    protected List tables;
    protected List columns;
    protected long[] csMap;
    protected long[] stMap;
    protected long[] tcMap;
    protected List tempCATList;
    protected List tempCSTList;
    protected List tempTblList;
    protected List tempClnList;
    protected String strCAT;
    protected String strCST;
    protected String strTbl;
    protected String strCln;

    public TablesColumnsCollector() {
    }

    public TablesColumnsCollector(boolean fullStructure) {
        this.fullStructure = fullStructure;
    }

    public void init() {
        this.catalogs = null;
        this.schemas = null;
        this.tables = null;
        this.columns = null;
        this.csMap = null;
        this.stMap = null;
        this.tcMap = null;
        this.tempCATList = new ArrayList();
        this.tempCSTList = new ArrayList();
        this.tempTblList = new ArrayList();
        this.tempClnList = new ArrayList();
        this.strCAT = "%%%%";
        this.strCST = "%%%%";
        this.strTbl = "%%%%";
        this.strCln = "%%%%";
    }

    public String updateNullValue(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public void addCatalogName(String catalogName) {
        String strCurr = catalogName = this.updateNullValue(catalogName);
        if (!this.strCAT.equalsIgnoreCase(strCurr)) {
            this.tempCATList.add(strCurr);
            this.strCAT = strCurr;
        }
    }

    public void addSchemaName(String catalogName, String schemaName) {
        catalogName = this.updateNullValue(catalogName);
        schemaName = this.updateNullValue(schemaName);
        this.addCatalogName(catalogName);
        String strCurr = String.valueOf(schemaName) + "%" + catalogName;
        if (!this.strCST.equalsIgnoreCase(strCurr)) {
            this.tempCSTList.add(strCurr);
            this.strCST = strCurr;
        }
    }

    public void addTableName(String catalogName, String schemaName, String tableName) {
        String strCurr;
        catalogName = this.updateNullValue(catalogName);
        schemaName = this.updateNullValue(schemaName);
        tableName = this.updateNullValue(tableName);
        this.addSchemaName(catalogName, schemaName);
        String string = strCurr = this.fullStructure ? String.valueOf(tableName) + "%" + schemaName + "%" + catalogName : String.valueOf(tableName) + "%" + schemaName;
        if (!this.strTbl.equalsIgnoreCase(strCurr)) {
            this.tempTblList.add(strCurr);
            this.strTbl = strCurr;
        }
    }

    public void addColumnName(String catalogName, String schemaName, String tableName, String columnName) {
        String strCurr;
        catalogName = this.updateNullValue(catalogName);
        schemaName = this.updateNullValue(schemaName);
        tableName = this.updateNullValue(tableName);
        columnName = this.updateNullValue(columnName);
        this.addTableName(catalogName, schemaName, tableName);
        String string = strCurr = this.fullStructure ? String.valueOf(columnName) + "%" + tableName + "%" + schemaName + "%" + catalogName : String.valueOf(columnName) + "%" + tableName;
        if (!this.strCln.equalsIgnoreCase(strCurr)) {
            this.tempClnList.add(strCurr);
            this.strCln = strCurr;
        }
    }

    protected void copyWithoutDuplicates(List arrTmp, List formList) {
        String strPrev = null;
        String strCurr = null;
        int i = 0;
        while (i < arrTmp.size()) {
            strCurr = (String)arrTmp.get(i);
            if (!(strPrev == strCurr || strPrev != null && strPrev.equalsIgnoreCase(strCurr))) {
                strPrev = strCurr;
                formList.add(strCurr);
            }
            ++i;
        }
    }

    protected void copyIncludeDuplicates(List arrTmp, List formList) {
        int i = 0;
        while (i < arrTmp.size()) {
            String strCurr = (String)arrTmp.get(i);
            formList.add(strCurr);
            ++i;
        }
    }

    protected int adjustList(List tempList, List formList) {
        ArrayList<String> arrTmp = new ArrayList<String>();
        Collections.sort(tempList, String.CASE_INSENSITIVE_ORDER);
        String strPrev = null;
        String strCurr = null;
        int i = 0;
        int j = 0;
        while (i < tempList.size()) {
            strCurr = (String)tempList.get(i);
            if (!(strPrev == strCurr || strPrev != null && strPrev.equalsIgnoreCase(strCurr))) {
                strPrev = strCurr;
                String[] atc = strCurr.split("%", 2);
                tempList.set(j++, strCurr);
                arrTmp.add(this.fullStructure ? strCurr : atc[0]);
            }
            ++i;
        }
        if (this.fullStructure) {
            this.copyIncludeDuplicates(arrTmp, formList);
        } else {
            Collections.sort(arrTmp, String.CASE_INSENSITIVE_ORDER);
            this.copyWithoutDuplicates(arrTmp, formList);
        }
        arrTmp = null;
        return j;
    }

    protected void adjustMap(long[] xMap, List tempList, List formList0, List formList1) {
        int j = xMap.length;
        int i = 0;
        while (i < j) {
            String strCurr = (String)tempList.get(i);
            String[] atc = strCurr.split("%", 2);
            String tmp = atc[1];
            int keyT = Collections.binarySearch(formList1, tmp, String.CASE_INSENSITIVE_ORDER);
            if (keyT < 0 || keyT >= formList1.size() || !tmp.equalsIgnoreCase((String)formList1.get(keyT))) {
                keyT = Integer.MAX_VALUE;
            }
            tmp = atc[0];
            int keyC = this.fullStructure ? i : Collections.binarySearch(formList0, tmp, String.CASE_INSENSITIVE_ORDER);
            String string = tmp = this.fullStructure ? strCurr : tmp;
            if (keyC < 0 || keyC >= formList0.size() || !tmp.equalsIgnoreCase((String)formList0.get(keyC))) {
                keyC = Integer.MAX_VALUE;
            }
            xMap[i] = (long)keyT << 32 | (long)keyC;
            ++i;
        }
        Arrays.sort(xMap);
    }

    public void adjust() {
        int size;
        this.strCAT = null;
        this.strCST = null;
        this.strTbl = null;
        this.strCln = null;
        this.catalogs = new ArrayList();
        if (this.tempCATList != null) {
            Collections.sort(this.tempCATList, String.CASE_INSENSITIVE_ORDER);
            this.copyWithoutDuplicates(this.tempCATList, this.catalogs);
            this.tempCATList = null;
        }
        this.schemas = new ArrayList();
        this.csMap = new long[0];
        if (this.tempCSTList != null) {
            size = this.adjustList(this.tempCSTList, this.schemas);
            this.csMap = new long[size];
            this.adjustMap(this.csMap, this.tempCSTList, this.schemas, this.catalogs);
            this.tempCSTList = null;
        }
        this.tables = new ArrayList();
        this.stMap = new long[0];
        if (this.tempTblList != null) {
            size = this.adjustList(this.tempTblList, this.tables);
            this.stMap = new long[size];
            this.adjustMap(this.stMap, this.tempTblList, this.tables, this.schemas);
            this.tempTblList = null;
        }
        this.columns = new ArrayList();
        this.tcMap = new long[0];
        if (this.tempClnList != null) {
            size = this.adjustList(this.tempClnList, this.columns);
            this.tcMap = new long[size];
            this.adjustMap(this.tcMap, this.tempClnList, this.columns, this.tables);
            this.tempClnList = null;
        }
    }

    public static final Bounds binaryBoundsSearch(List list, String prefix) {
        int cmp;
        String midVal;
        Bounds bounds = new Bounds();
        if (list.isEmpty()) {
            bounds.nH = 0;
            bounds.nL = 0;
            return bounds;
        }
        prefix = prefix.toUpperCase();
        int low = 0;
        int high = list.size() - 1;
        int mid = low + high >> 1;
        while (low <= high) {
            mid = low + high >> 1;
            String midVal2 = ((String)list.get(mid)).toUpperCase();
            int cmp2 = midVal2.compareToIgnoreCase(prefix);
            int n = cmp2 = midVal2.startsWith(prefix) ? 0 : cmp2;
            if (cmp2 < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp2 <= 0) break;
            high = mid - 1;
        }
        int low2 = mid;
        int high2 = mid;
        while (low <= high2) {
            mid = low + high2 >> 1;
            midVal = ((String)list.get(mid)).toUpperCase();
            cmp = midVal.compareToIgnoreCase(prefix);
            int n = cmp = midVal.startsWith(prefix) ? 0 : cmp;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) continue;
            high2 = mid - 1;
        }
        while (low2 <= high) {
            mid = low2 + high >> 1;
            midVal = ((String)list.get(mid)).toUpperCase();
            cmp = midVal.compareToIgnoreCase(prefix);
            int n = cmp = midVal.startsWith(prefix) ? 0 : cmp;
            if (cmp <= 0) {
                low2 = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        if (low < list.size()) {
            while (low >= 0 && ((String)list.get(low)).toUpperCase().startsWith(prefix)) {
                --low;
            }
            ++low;
        }
        if (high < low) {
            high = low;
        }
        while (high < list.size() && ((String)list.get(high)).toUpperCase().startsWith(prefix)) {
            ++high;
        }
        bounds.nL = low;
        bounds.nH = high;
        return bounds;
    }

    protected String correctName(String input) {
        if (!this.fullStructure) {
            return input;
        }
        String[] atc = input.split("%", 2);
        return atc[0];
    }

    protected void correctNames(List res) {
        if (!this.fullStructure) {
            return;
        }
        int i = 0;
        while (i < res.size()) {
            String strCurr = (String)res.get(i);
            String[] atc = strCurr.split("%", 2);
            res.set(i, atc[0]);
            ++i;
        }
    }

    protected List getXNames(List xArray, String prefix) {
        ArrayList res = new ArrayList();
        if (xArray == null) {
            return res;
        }
        if (prefix != null) {
            prefix = prefix.toUpperCase();
        }
        if (prefix == null) {
            res.addAll(xArray);
        } else {
            Bounds bounds = TablesColumnsCollector.binaryBoundsSearch(xArray, prefix);
            while (bounds.nL < bounds.nH) {
                res.add(xArray.get(bounds.nL));
                ++bounds.nL;
            }
        }
        return res;
    }

    public List getMatchingCatalogNames(String prefix) {
        List res = this.getXNames(this.catalogs, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingSchemaNames(String prefix) {
        List res = this.getXNames(this.schemas, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingTableNames(String prefix) {
        List res = this.getXNames(this.tables, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingColumnNames(String prefix) {
        List res = this.getXNames(this.columns, prefix);
        this.correctNames(res);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    protected List getXNames(List xArray1, long[] xxMap, List xArray2, String name, String prefix) {
        block14: {
            block15: {
                block13: {
                    res = new ArrayList<E>();
                    if (xArray1 == null) {
                        return res;
                    }
                    if (name != null) {
                        name = name.toUpperCase();
                    }
                    if (prefix != null) {
                        prefix = prefix.toUpperCase();
                    }
                    if (name != null || prefix != null) break block13;
                    res.addAll(xArray1);
                    break block14;
                }
                if (name != null) break block15;
                bounds = TablesColumnsCollector.binaryBoundsSearch(xArray1, prefix);
                while (bounds.nL < bounds.nH) {
                    res.add(xArray1.get(bounds.nL));
                    ++bounds.nL;
                }
                break block14;
            }
            if (xArray2 == null || xxMap == null) {
                return res;
            }
            bounds = TablesColumnsCollector.binaryBoundsSearch(xArray2, name);
            while (bounds.nL < bounds.nH) {
                block12: {
                    block16: {
                        keyT = bounds.nL;
                        itemT = (String)xArray2.get(keyT);
                        if (!this.fullStructure) break block16;
                        if (!itemT.toUpperCase().startsWith(name)) break block12;
                        name = this.correctName(name);
                        itemT = this.correctName(itemT);
                    }
                    if (!name.equalsIgnoreCase(itemT)) break block12;
                    keyTlong = (long)keyT << 32;
                    i = Arrays.binarySearch(xxMap, keyTlong);
                    if (i < 0) {
                        i = -i - 1;
                    }
                    if (prefix != null) ** GOTO lbl55
                    while (i < xxMap.length) {
                        if (keyTlong == (xxMap[i] & -4294967296L)) {
                            keyC = (int)(xxMap[i] & 0xFFFFFFFFL);
                            if (keyC >= 0 && keyC < xArray1.size()) {
                                res.add(xArray1.get(keyC));
                            }
                            ++i;
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                    while (keyTlong == (xxMap[i] & -4294967296L)) {
                        keyC = (int)(xxMap[i] & 0xFFFFFFFFL);
                        if (keyC >= 0 && keyC < xArray1.size() && ((String)xArray1.get(keyC)).toUpperCase().startsWith(prefix)) {
                            res.add(xArray1.get(keyC));
                        }
                        ++i;
lbl55:
                        // 2 sources

                        if (i < xxMap.length) continue;
                    }
                }
                ++bounds.nL;
            }
        }
        return res;
    }

    public List getCatalogNames() {
        ArrayList res = new ArrayList();
        if (this.catalogs != null) {
            res.addAll(this.catalogs);
        }
        return res;
    }

    public List getMatchingSchemaNames(String catalogName, String prefix) {
        List res = this.getXNames(this.schemas, this.csMap, this.catalogs, catalogName, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingTablesNames(String schemaName, String prefix) {
        List res = this.getXNames(this.tables, this.stMap, this.schemas, schemaName, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingColumnNames(String tableName, String prefix) {
        List res = this.getXNames(this.columns, this.tcMap, this.tables, tableName, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingTablesNames(String catalogName, String schemaName, String prefix) {
        catalogName = this.updateNullValue(catalogName);
        schemaName = this.updateNullValue(schemaName);
        schemaName = schemaName + "%" + catalogName;
        List res = this.getXNames(this.tables, this.stMap, this.schemas, schemaName, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingColumnNames(String schemaName, String tableName, String prefix) {
        schemaName = this.updateNullValue(schemaName);
        tableName = this.updateNullValue(tableName);
        tableName = tableName + "%" + schemaName;
        List res = this.getXNames(this.columns, this.tcMap, this.tables, tableName, prefix);
        this.correctNames(res);
        return res;
    }

    public List getMatchingColumnNames(String catalogName, String schemaName, String tableName, String prefix) {
        catalogName = this.updateNullValue(catalogName);
        schemaName = this.updateNullValue(schemaName);
        tableName = this.updateNullValue(tableName);
        tableName = tableName + "%" + schemaName + "%" + catalogName;
        List res = this.getXNames(this.columns, this.tcMap, this.tables, tableName, prefix);
        this.correctNames(res);
        return res;
    }

    public static final class Bounds {
        public int nL = 0;
        public int nH = 0;
    }
}

